package ru.yandex.direct.core.entity.banner.repository.old.mapper;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.banner.model.old.OldBannerMeasurer;
import ru.yandex.direct.core.entity.banner.model.old.OldBannerMeasurerSystem;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplier;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplierBuilder;

import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_MEASURERS;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;

@ParametersAreNonnullByDefault
@Deprecated
public class BannerMeasurerMapperProvider {

    private static final JooqMapperWithSupplier<OldBannerMeasurer> MAPPER = createMapper();

    private BannerMeasurerMapperProvider() {
    }

    public static JooqMapperWithSupplier<OldBannerMeasurer> getBannerMeasurerMapper() {
        return MAPPER;
    }

    private static JooqMapperWithSupplier<OldBannerMeasurer> createMapper() {

        return JooqMapperWithSupplierBuilder.builder(OldBannerMeasurer::new)
                .map(property(OldBannerMeasurer.BANNER_ID, BANNER_MEASURERS.BID))
                .map(convertibleProperty(
                        OldBannerMeasurer.BANNER_MEASURER_SYSTEM,
                        BANNER_MEASURERS.MEASURER_SYSTEM,
                        OldBannerMeasurerSystem::fromSource,
                        OldBannerMeasurerSystem::toSource))
                .map(convertibleProperty(
                        OldBannerMeasurer.PARAMS,
                        BANNER_MEASURERS.PARAMS,
                        dbValue -> dbValue == null ? "" : dbValue,
                        javaValue -> "".equals(javaValue) ? null : javaValue))
                .map(convertibleProperty(
                        OldBannerMeasurer.HAS_INTEGRATION,
                        BANNER_MEASURERS.HAS_INTEGRATION,
                        dbValue -> dbValue != null && dbValue == 1L,
                        javaValue -> (javaValue != null && javaValue) ? 1L : 0L))
                .build();
    }
}
