package ru.yandex.direct.core.entity.banner.repository.old.mapper;

import java.math.BigDecimal;
import java.math.RoundingMode;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.banner.model.old.OldBannerPrice;
import ru.yandex.direct.core.entity.banner.model.old.OldBannerPricesCurrency;
import ru.yandex.direct.core.entity.banner.model.old.OldBannerPricesPrefix;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplier;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplierBuilder;

import static ru.yandex.direct.dbschema.ppc.tables.BannerPrices.BANNER_PRICES;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;

/**
 * Маппер для цены на баннере.
 */
@ParametersAreNonnullByDefault
@Deprecated
public class BannerPriceMapperProvider {

    private static final JooqMapperWithSupplier<OldBannerPrice> MAPPER = createMapper();

    private BannerPriceMapperProvider() {
    }

    /**
     * @return {@link JooqMapperWithSupplier} для цен на беннере.
     */
    public static JooqMapperWithSupplier<OldBannerPrice> getBannerPriceMapper() {
        return MAPPER;
    }

    private static JooqMapperWithSupplier<OldBannerPrice> createMapper() {
        return JooqMapperWithSupplierBuilder.builder(OldBannerPrice::new)
                .map(convertibleProperty(OldBannerPrice.PRICE, BANNER_PRICES.PRICE,
                        BannerPriceMapperProvider::roundPriceHalfUp,
                        BannerPriceMapperProvider::roundPriceHalfUp))
                .map(convertibleProperty(OldBannerPrice.PRICE_OLD, BANNER_PRICES.PRICE_OLD,
                        BannerPriceMapperProvider::roundPriceHalfUp,
                        BannerPriceMapperProvider::roundPriceHalfUp))
                .map(convertibleProperty(OldBannerPrice.CURRENCY, BANNER_PRICES.CURRENCY,
                        OldBannerPricesCurrency::fromSource,
                        OldBannerPricesCurrency::toSource))
                .map(convertibleProperty(OldBannerPrice.PREFIX, BANNER_PRICES.PREFIX,
                        OldBannerPricesPrefix::fromSource, OldBannerPricesPrefix::toSource))
                .build();
    }

    private static BigDecimal roundPriceHalfUp(@Nullable BigDecimal price) {
        return price == null ? null : price.setScale(2, RoundingMode.HALF_UP);
    }
}
