package ru.yandex.direct.core.entity.banner.repository.old.mapper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.apache.commons.lang3.StringUtils;
import org.jooq.Field;
import org.jooq.TableField;

import ru.yandex.direct.core.entity.banner.model.BannerFlags;
import ru.yandex.direct.core.entity.banner.model.old.OldBanner;
import ru.yandex.direct.core.entity.banner.model.old.OldBannerStatusModerate;
import ru.yandex.direct.core.entity.banner.model.old.OldBannerStatusPostModerate;
import ru.yandex.direct.core.entity.banner.model.old.OldBannerType;
import ru.yandex.direct.core.entity.banner.model.old.StatusPhoneFlagModerate;
import ru.yandex.direct.dbschema.ppc.tables.Banners;
import ru.yandex.direct.dbschema.ppc.tables.records.BannersRecord;
import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.jooqmapperhelper.JooqUpdateBuilder;
import ru.yandex.direct.model.AppliedChanges;

import static java.util.Arrays.asList;
import static ru.yandex.direct.core.entity.banner.repository.old.mapper.Constants.Opts.GEO_FLAG;
import static ru.yandex.direct.dbschema.ppc.Tables.AGGREGATOR_DOMAINS;
import static ru.yandex.direct.dbschema.ppc.Tables.PERF_CREATIVES;
import static ru.yandex.direct.dbschema.ppc.tables.BannerDisplayHrefs.BANNER_DISPLAY_HREFS;
import static ru.yandex.direct.dbschema.ppc.tables.Banners.BANNERS;
import static ru.yandex.direct.dbschema.ppc.tables.FilterDomain.FILTER_DOMAIN;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;
import static ru.yandex.direct.jooqmapper.read.ReaderBuilders.fromField;
import static ru.yandex.direct.jooqmapper.write.WriterBuilders.fromProperty;

@ParametersAreNonnullByDefault
@Deprecated
public class CommonBannerMapperProvider {

    private static final JooqMapper<OldBanner> MAPPER = createMapper();

    private static final Collection<TableField<?, ?>> SIMPLE_BANNER_FIELDS =
            asList(BANNERS.BID, BANNERS.PID, BANNERS.CID, BANNERS.FLAGS, BANNERS.STATUS_MODERATE);

    private static final Collection<Field<?>> BANNER_WITH_LANG_FIELDS_READ_FIELDS = Arrays.asList(
            BANNERS.BID,
            BANNERS.PID,
            BANNERS.CID,
            BANNERS.BANNER_TYPE,
            BANNERS.STATUS_MODERATE,
            BANNERS.FLAGS,
            BANNERS.TITLE,
            BANNERS.TITLE_EXTENSION,
            BANNERS.BODY,
            BANNERS.LANGUAGE,
            PERF_CREATIVES.MODERATE_INFO);

    private CommonBannerMapperProvider() {
    }

    /**
     * Получить маппер абстрактной модели {@link OldBanner}.
     * Этот маппер ничего не знает о подтипах и специфичных для них таблицах.
     * Предполагается использование для расширения с помощью передачи его в
     * {@link JooqMapperBuilder} модели конкретного типа.
     *
     * @return Базовый маппер моделей наследников {@link OldBanner}.
     */
    public static JooqMapper<OldBanner> getCommonBannerMapper() {
        return MAPPER;
    }

    public static Collection<TableField<?, ?>> getSimpleBannerFields() {
        return SIMPLE_BANNER_FIELDS;
    }

    public static Collection<Field<?>> getBannerWithLangFieldsReadFields() {
        return BANNER_WITH_LANG_FIELDS_READ_FIELDS;
    }

    /**
     * Получает значение ppc.banners.opts из заданных полей баннера
     *
     * @return значение ppc.banners.opts для записи в базу
     */
    public static String bannerOptsToDb(Boolean geoFlag) {
        List<String> opts = new ArrayList<>();
        if (geoFlag) {
            opts.add(GEO_FLAG);
        }
        return StringUtils.join(opts, ",");
    }

    private static JooqMapper<OldBanner> createMapper() {
        return JooqMapperBuilder.<OldBanner>builder()
                .map(property(OldBanner.ID, BANNERS.BID))
                .map(property(OldBanner.AD_GROUP_ID, BANNERS.PID))
                .map(property(OldBanner.CAMPAIGN_ID, BANNERS.CID))
                .map(property(OldBanner.BS_BANNER_ID, BANNERS.BANNER_ID))
                .map(convertibleProperty(OldBanner.STATUS_BS_SYNCED, BANNERS.STATUS_BS_SYNCED,
                        BannerMappings::statusBsSyncedFromDb, BannerMappings::statusBsSyncedToDb))
                .map(convertibleProperty(OldBanner.BANNER_TYPE, BANNERS.BANNER_TYPE,
                        OldBannerType::fromSource, OldBannerType::toSource))
                .map(convertibleProperty(OldBanner.IS_MOBILE, BANNERS.TYPE,
                        BannerMappings::isMobileFromDb, BannerMappings::isMobileToDb))
                .map(convertibleProperty(OldBanner.STATUS_MODERATE, BANNERS.STATUS_MODERATE,
                        OldBannerStatusModerate::fromSource, OldBannerStatusModerate::toSource))
                .map(convertibleProperty(OldBanner.STATUS_POST_MODERATE, BANNERS.STATUS_POST_MODERATE,
                        OldBannerStatusPostModerate::fromSource, OldBannerStatusPostModerate::toSource))
                .map(convertibleProperty(OldBanner.PHONE_FLAG, BANNERS.PHONEFLAG,
                        StatusPhoneFlagModerate::fromSource, StatusPhoneFlagModerate::toSource))
                .map(convertibleProperty(OldBanner.STATUS_SHOW, BANNERS.STATUS_SHOW,
                        BannerMappings::statusShowFromDb, BannerMappings::statusShowToDb))
                .map(convertibleProperty(OldBanner.STATUS_ACTIVE, BANNERS.STATUS_ACTIVE,
                        BannerMappings::statusActiveFromDb, BannerMappings::statusActiveToDb))
                .map(convertibleProperty(OldBanner.STATUS_ARCHIVED, BANNERS.STATUS_ARCH,
                        BannerMappings::statusArchivedFromDb, BannerMappings::statusArchivedToDb))
                .map(property(OldBanner.HREF, BANNERS.HREF))
                .map(property(OldBanner.AGGREGATOR_DOMAIN, AGGREGATOR_DOMAINS.PSEUDO_DOMAIN))

                // Для получения домена используется поле таблицы banners, а не domains
                .map(property(OldBanner.DOMAIN_ID, BANNERS.DOMAIN_ID))
                .map(property(OldBanner.DOMAIN, BANNERS.DOMAIN))
                .map(property(OldBanner.REVERSE_DOMAIN, BANNERS.REVERSE_DOMAIN))

                .map(convertibleProperty(OldBanner.LANGUAGE, BANNERS.LANGUAGE,
                        BannerMappings::languageFromDb, BannerMappings::languageToDb))

                .map(convertibleProperty(OldBanner.FLAGS, BANNERS.FLAGS,
                        BannerFlags::fromSource, BannerFlags::toSource))
                .map(property(OldBanner.YA_CONTEXT_CATEGORIES, BANNERS.YACONTEXT_CATEGORIES))
                .map(property(OldBanner.LAST_CHANGE, BANNERS.LAST_CHANGE))
                .readProperty(OldBanner.GEO_FLAG, fromField(BANNERS.OPTS).by(opts -> opts.contains(GEO_FLAG)))
                .writeField(BANNERS.OPTS,
                        fromProperty(OldBanner.GEO_FLAG).by(CommonBannerMapperProvider::bannerOptsToDb))
                .writeField(BANNER_DISPLAY_HREFS.BID, fromProperty(OldBanner.ID))
                // FILTER_DOMAIN заполняется отдельно
                .readProperty(OldBanner.FILTER_DOMAIN, fromField(FILTER_DOMAIN.FILTER_DOMAIN_))
                .build();
    }

    public static <T extends OldBanner> JooqUpdateBuilder<BannersRecord, T> createBannersCommonUpdateBuilder(
            Collection<AppliedChanges<T>> changes) {
        JooqUpdateBuilder<BannersRecord, T> builder = new JooqUpdateBuilder<>(Banners.BANNERS.BID, changes);

        builder.processProperty(OldBanner.HREF, Banners.BANNERS.HREF);
        builder.processProperty(OldBanner.DOMAIN_ID, Banners.BANNERS.DOMAIN_ID);
        builder.processProperty(OldBanner.DOMAIN, Banners.BANNERS.DOMAIN);
        builder.processProperty(OldBanner.REVERSE_DOMAIN, Banners.BANNERS.REVERSE_DOMAIN);

        builder.processProperty(OldBanner.PHONE_FLAG, Banners.BANNERS.PHONEFLAG, StatusPhoneFlagModerate::toSource);

        builder.processProperty(OldBanner.FLAGS, Banners.BANNERS.FLAGS, BannerFlags::toSource);
        builder.processProperty(
                OldBanner.STATUS_BS_SYNCED, Banners.BANNERS.STATUS_BS_SYNCED, BannerMappings::statusBsSyncedToDb);
        builder.processProperty(
                OldBanner.STATUS_SHOW, Banners.BANNERS.STATUS_SHOW, BannerMappings::statusShowToDb);
        builder.processProperty(OldBanner.STATUS_MODERATE, Banners.BANNERS.STATUS_MODERATE, OldBannerStatusModerate::toSource);
        builder.processProperty(
                OldBanner.STATUS_POST_MODERATE, Banners.BANNERS.STATUS_POST_MODERATE, OldBannerStatusPostModerate::toSource);
        builder.processProperty(OldBanner.LAST_CHANGE, Banners.BANNERS.LAST_CHANGE);
        builder.processProperty(OldBanner.STATUS_ARCHIVED, Banners.BANNERS.STATUS_ARCH,
                BannerMappings::statusArchivedToDb);
        builder.processProperty(OldBanner.LANGUAGE, Banners.BANNERS.LANGUAGE, BannerMappings::languageToDb);

        return builder;
    }
}
