package ru.yandex.direct.core.entity.banner.repository.old.mapper;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.old.OldContentPromotionBanner;
import ru.yandex.direct.dbschema.ppc.tables.BannersContentPromotion;
import ru.yandex.direct.dbschema.ppc.tables.records.BannersContentPromotionRecord;
import ru.yandex.direct.dbschema.ppc.tables.records.BannersRecord;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplier;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplierBuilder;
import ru.yandex.direct.jooqmapperhelper.JooqUpdateBuilder;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.core.entity.banner.repository.old.mapper.CommonBannerMapperProvider.createBannersCommonUpdateBuilder;
import static ru.yandex.direct.core.entity.banner.repository.old.mapper.CommonBannerMapperProvider.getCommonBannerMapper;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS_CONTENT_PROMOTION;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;
import static ru.yandex.direct.jooqmapper.write.WriterBuilders.fromProperty;

/**
 * Реализации мапперов в бд для объявлений продвижения контента.
 */
@Component
@ParametersAreNonnullByDefault
@Deprecated
public class ContentPromotionBannerMapperProvider {

    private static final JooqMapperWithSupplier<OldContentPromotionBanner>
            CONTENT_PROMOTION_BANNER_MAPPER = createBannerMapper();

    private ContentPromotionBannerMapperProvider() {
    }

    /**
     * @return {@link JooqMapperWithSupplier} для баннера продвижения контента {@link OldContentPromotionBanner}.
     * @see CommonBannerMapperProvider
     */
    public static JooqMapperWithSupplier<OldContentPromotionBanner> getContentPromotionBannerMapper() {
        return CONTENT_PROMOTION_BANNER_MAPPER;
    }

    /**
     * @param appliedChanges изменения моделей при обновлении
     * @return {@link JooqUpdateBuilder} баннера продвижения контента {@link OldContentPromotionBanner}
     * для таблицы ppc.banners.
     */
    public static JooqUpdateBuilder<BannersRecord, OldContentPromotionBanner> createBannersUpdateBuilder(
            Collection<AppliedChanges<OldContentPromotionBanner>> appliedChanges) {
        JooqUpdateBuilder<BannersRecord, OldContentPromotionBanner> builder =
                createBannersCommonUpdateBuilder(appliedChanges);

        builder.processProperty(OldContentPromotionBanner.TITLE, BANNERS.TITLE);
        builder.processProperty(OldContentPromotionBanner.BODY, BANNERS.BODY);

        return builder;
    }

    /**
     * @param appliedChanges изменения моделей при обновлении
     * @return {@link JooqUpdateBuilder} баннера продвижения контента {@link OldContentPromotionBanner} для таблицы
     * ppc.banners_content_promotion.
     */
    public static JooqUpdateBuilder<BannersContentPromotionRecord, OldContentPromotionBanner>
    createBannersContentPromotionUpdateBuilder(
            Collection<AppliedChanges<OldContentPromotionBanner>> appliedChanges
    ) {
        JooqUpdateBuilder<BannersContentPromotionRecord, OldContentPromotionBanner> builder
                = new JooqUpdateBuilder<>(BannersContentPromotion.BANNERS_CONTENT_PROMOTION.BID,
                appliedChanges);

        builder.processProperty(OldContentPromotionBanner.CONTENT_PROMOTION_ID,
                BannersContentPromotion.BANNERS_CONTENT_PROMOTION.CONTENT_PROMOTION_ID);
        builder.processProperty(OldContentPromotionBanner.VISIT_URL,
                BannersContentPromotion.BANNERS_CONTENT_PROMOTION.VISIT_URL);

        return builder;
    }

    private static JooqMapperWithSupplier<OldContentPromotionBanner> createBannerMapper() {
        return JooqMapperWithSupplierBuilder.builder(getCommonBannerMapper(), OldContentPromotionBanner::new)
                .map(property(OldContentPromotionBanner.TITLE, BANNERS.TITLE))
                .map(property(OldContentPromotionBanner.BODY, BANNERS.BODY))

                .writeField(BANNERS_CONTENT_PROMOTION.BID, fromProperty(OldContentPromotionBanner.ID))
                .map(property(OldContentPromotionBanner.CONTENT_PROMOTION_ID,
                        BANNERS_CONTENT_PROMOTION.CONTENT_PROMOTION_ID))
                .map(property(OldContentPromotionBanner.VISIT_URL, BANNERS_CONTENT_PROMOTION.VISIT_URL))
                .build();
    }
}
