package ru.yandex.direct.core.entity.banner.repository.old.mapper;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.old.OldBannerCreativeStatusModerate;
import ru.yandex.direct.core.entity.banner.model.old.OldCpcVideoBanner;
import ru.yandex.direct.core.entity.banner.turbolanding.model.OldBannerTurboLandingStatusModerate;
import ru.yandex.direct.dbschema.ppc.tables.Banners;
import ru.yandex.direct.dbschema.ppc.tables.records.BannersRecord;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplier;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplierBuilder;
import ru.yandex.direct.jooqmapperhelper.JooqUpdateBuilder;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.core.entity.banner.repository.old.mapper.CommonBannerMapperProvider.createBannersCommonUpdateBuilder;
import static ru.yandex.direct.core.entity.banner.repository.old.mapper.CommonBannerMapperProvider.getCommonBannerMapper;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_TURBOLANDINGS;
import static ru.yandex.direct.dbschema.ppc.tables.BannersPerformance.BANNERS_PERFORMANCE;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;

@Component
@ParametersAreNonnullByDefault
@Deprecated
public class CpcVideoBannerMapperProvider {

    private static final JooqMapperWithSupplier<OldCpcVideoBanner> CPC_VIDEO_BANNER_BANNER =
            createCpcVideoBannerBanner();

    private CpcVideoBannerMapperProvider() {
    }

    /**
     * @return {@link JooqMapperWithSupplier} для баннера с кликовым видео {@link OldCpcVideoBanner}.
     * @see CommonBannerMapperProvider
     */
    public static JooqMapperWithSupplier<OldCpcVideoBanner> getCpcVideoBannerMapper() {
        return CPC_VIDEO_BANNER_BANNER;
    }

    /**
     * @param appliedChanges изменения моделей при обновлении
     * @return {@link JooqUpdateBuilder} для медийных объявлений {@link OldCpcVideoBanner}.
     */
    public static JooqUpdateBuilder<BannersRecord, OldCpcVideoBanner> createCpcVideoBannerUpdateBuilder(
            Collection<AppliedChanges<OldCpcVideoBanner>> appliedChanges) {
        JooqUpdateBuilder<BannersRecord, OldCpcVideoBanner> builder = createBannersCommonUpdateBuilder(appliedChanges);
        builder.processProperty(OldCpcVideoBanner.TITLE, Banners.BANNERS.TITLE);
        builder.processProperty(OldCpcVideoBanner.BODY, Banners.BANNERS.BODY);

        return builder;
    }

    private static JooqMapperWithSupplier<OldCpcVideoBanner> createCpcVideoBannerBanner() {
        return JooqMapperWithSupplierBuilder.builder(getCommonBannerMapper(), OldCpcVideoBanner::new)
                .map(property(OldCpcVideoBanner.TITLE, BANNERS.TITLE))
                .map(property(OldCpcVideoBanner.BODY, BANNERS.BODY))
                .map(property(OldCpcVideoBanner.CREATIVE_ID, BANNERS_PERFORMANCE.CREATIVE_ID))
                .map(convertibleProperty(OldCpcVideoBanner.CREATIVE_STATUS_MODERATE, BANNERS_PERFORMANCE.STATUS_MODERATE,
                        OldBannerCreativeStatusModerate::fromSource, OldBannerCreativeStatusModerate::toSource))
                .map(property(OldCpcVideoBanner.TURBO_LANDING_ID, BANNER_TURBOLANDINGS.TL_ID))
                .map(convertibleProperty(OldCpcVideoBanner.TURBO_LANDING_STATUS_MODERATE,
                        BANNER_TURBOLANDINGS.STATUS_MODERATE,
                        OldBannerTurboLandingStatusModerate::fromSource, OldBannerTurboLandingStatusModerate::toSource))
                .build();
    }
}
