package ru.yandex.direct.core.entity.banner.repository.old.mapper;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.banner.model.old.OldBannerCreativeStatusModerate;
import ru.yandex.direct.core.entity.banner.model.old.OldCpmAudioBanner;
import ru.yandex.direct.dbschema.ppc.tables.records.BannersRecord;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplier;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplierBuilder;
import ru.yandex.direct.jooqmapperhelper.JooqUpdateBuilder;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.core.entity.banner.repository.old.mapper.CommonBannerMapperProvider.createBannersCommonUpdateBuilder;
import static ru.yandex.direct.core.entity.banner.repository.old.mapper.CommonBannerMapperProvider.getCommonBannerMapper;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS_PERFORMANCE;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;

@ParametersAreNonnullByDefault
@Deprecated
public class CpmAudioBannerMapperProvider {

    private static final JooqMapperWithSupplier<OldCpmAudioBanner> CPM_BANNER_MAPPER =
            createCpmAudioBannerMapper();

    private CpmAudioBannerMapperProvider() {
    }

    /**
     * @return {@link JooqMapperWithSupplier} для медийного Audio объявления {@link OldCpmAudioBanner}.
     * @see CommonBannerMapperProvider
     */
    public static JooqMapperWithSupplier<OldCpmAudioBanner> getCpmAudioBannerMapper() {
        return CPM_BANNER_MAPPER;
    }

    /**
     * @param appliedChanges изменения моделей при обновлении
     * @return {@link JooqUpdateBuilder} для медийных Audio объявлений {@link OldCpmAudioBanner}.
     */
    public static JooqUpdateBuilder<BannersRecord, OldCpmAudioBanner> createCpmAudioBannerUpdateBuilder(
            Collection<AppliedChanges<OldCpmAudioBanner>> appliedChanges) {
        return createBannersCommonUpdateBuilder(appliedChanges);
    }

    private static JooqMapperWithSupplier<OldCpmAudioBanner> createCpmAudioBannerMapper() {
        return JooqMapperWithSupplierBuilder.builder(getCommonBannerMapper(), OldCpmAudioBanner::new)
                .map(property(OldCpmAudioBanner.CREATIVE_ID, BANNERS_PERFORMANCE.CREATIVE_ID))
                .map(convertibleProperty(OldCpmAudioBanner.CREATIVE_STATUS_MODERATE, BANNERS_PERFORMANCE.STATUS_MODERATE,
                        OldBannerCreativeStatusModerate::fromSource, OldBannerCreativeStatusModerate::toSource))
                .build();
    }
}
