package ru.yandex.direct.core.entity.banner.repository.old.mapper;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.banner.model.old.OldBannerCreativeStatusModerate;
import ru.yandex.direct.core.entity.banner.model.old.OldCpmBanner;
import ru.yandex.direct.core.entity.banner.model.old.StatusBannerLogoModerate;
import ru.yandex.direct.core.entity.banner.turbolanding.model.OldBannerTurboLandingStatusModerate;
import ru.yandex.direct.dbschema.ppc.tables.Banners;
import ru.yandex.direct.dbschema.ppc.tables.records.BannersRecord;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplier;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplierBuilder;
import ru.yandex.direct.jooqmapperhelper.JooqUpdateBuilder;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.core.entity.banner.repository.old.mapper.CommonBannerMapperProvider.createBannersCommonUpdateBuilder;
import static ru.yandex.direct.core.entity.banner.repository.old.mapper.CommonBannerMapperProvider.getCommonBannerMapper;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS_PERFORMANCE;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_LOGOS;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_TURBOLANDINGS;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;

@ParametersAreNonnullByDefault
@Deprecated
public class CpmBannerMapperProvider {

    private static final JooqMapperWithSupplier<OldCpmBanner> CPM_BANNER_MAPPER = createCpmBannerMapper();

    private CpmBannerMapperProvider() {
    }

    /**
     * @return {@link JooqMapperWithSupplier} для медийного объявления {@link OldCpmBanner}.
     * @see CommonBannerMapperProvider
     */
    public static JooqMapperWithSupplier<OldCpmBanner> getCpmBannerMapper() {
        return CPM_BANNER_MAPPER;
    }

    /**
     * @param appliedChanges изменения моделей при обновлении
     * @return {@link JooqUpdateBuilder} для медийных объявлений {@link OldCpmBanner}.
     */
    public static JooqUpdateBuilder<BannersRecord, OldCpmBanner> createCpmBannerUpdateBuilder(
            Collection<AppliedChanges<OldCpmBanner>> appliedChanges) {
        JooqUpdateBuilder<BannersRecord, OldCpmBanner> bannerUpdateBuilder =
                createBannersCommonUpdateBuilder(appliedChanges);

        bannerUpdateBuilder.processProperty(OldCpmBanner.TITLE, Banners.BANNERS.TITLE);
        bannerUpdateBuilder.processProperty(OldCpmBanner.TITLE_EXTENSION, Banners.BANNERS.TITLE_EXTENSION);
        bannerUpdateBuilder.processProperty(OldCpmBanner.BODY, Banners.BANNERS.BODY);

        return bannerUpdateBuilder;
    }

    private static JooqMapperWithSupplier<OldCpmBanner> createCpmBannerMapper() {
        return JooqMapperWithSupplierBuilder.builder(getCommonBannerMapper(), OldCpmBanner::new)
                .map(property(OldCpmBanner.TITLE, BANNERS.TITLE))
                .map(property(OldCpmBanner.TITLE_EXTENSION, BANNERS.TITLE_EXTENSION))
                .map(property(OldCpmBanner.BODY, BANNERS.BODY))
                .map(property(OldCpmBanner.CREATIVE_ID, BANNERS_PERFORMANCE.CREATIVE_ID))
                .map(convertibleProperty(OldCpmBanner.CREATIVE_STATUS_MODERATE, BANNERS_PERFORMANCE.STATUS_MODERATE,
                        OldBannerCreativeStatusModerate::fromSource, OldBannerCreativeStatusModerate::toSource))
                .map(property(OldCpmBanner.TURBO_LANDING_ID, BANNER_TURBOLANDINGS.TL_ID))
                .map(convertibleProperty(OldCpmBanner.TURBO_LANDING_STATUS_MODERATE, BANNER_TURBOLANDINGS.STATUS_MODERATE,
                        OldBannerTurboLandingStatusModerate::fromSource, OldBannerTurboLandingStatusModerate::toSource))
                .map(property(OldCpmBanner.LOGO_IMAGE_HASH, BANNER_LOGOS.IMAGE_HASH))
                .map(convertibleProperty(OldCpmBanner.LOGO_STATUS_MODERATE, BANNER_LOGOS.STATUS_MODERATE,
                        StatusBannerLogoModerate::fromSource, StatusBannerLogoModerate::toSource))
                .build();
    }
}
