package ru.yandex.direct.core.entity.banner.repository.old.mapper;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.banner.model.old.OldBannerCreativeStatusModerate;
import ru.yandex.direct.core.entity.banner.model.old.OldCpmGeoPinBanner;
import ru.yandex.direct.dbschema.ppc.tables.records.BannersRecord;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplier;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplierBuilder;
import ru.yandex.direct.jooqmapperhelper.JooqUpdateBuilder;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.core.entity.banner.repository.old.mapper.CommonBannerMapperProvider.createBannersCommonUpdateBuilder;
import static ru.yandex.direct.core.entity.banner.repository.old.mapper.CommonBannerMapperProvider.getCommonBannerMapper;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS_PERFORMANCE;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_PERMALINKS;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;

@ParametersAreNonnullByDefault
@Deprecated
public class CpmGeoPinBannerMapperProvider {

    private static final JooqMapperWithSupplier<OldCpmGeoPinBanner> CPM_BANNER_MAPPER = createCpmGeoPinBannerMapper();

    private CpmGeoPinBannerMapperProvider() {
    }

    /**
     * @return {@link JooqMapperWithSupplier} для медийного пин объявления {@link OldCpmGeoPinBanner}.
     * @see CommonBannerMapperProvider
     */
    public static JooqMapperWithSupplier<OldCpmGeoPinBanner> getCpmGeoPinBannerMapper() {
        return CPM_BANNER_MAPPER;
    }

    /**
     * @param appliedChanges изменения моделей при обновлении
     * @return {@link JooqUpdateBuilder} для медийных пин объявлений {@link OldCpmGeoPinBanner}.
     */
    public static JooqUpdateBuilder<BannersRecord, OldCpmGeoPinBanner> createCpmGeoPinBannerUpdateBuilder(
            Collection<AppliedChanges<OldCpmGeoPinBanner>> appliedChanges) {
        return createBannersCommonUpdateBuilder(appliedChanges);
    }

    private static JooqMapperWithSupplier<OldCpmGeoPinBanner> createCpmGeoPinBannerMapper() {
        return JooqMapperWithSupplierBuilder.builder(getCommonBannerMapper(), OldCpmGeoPinBanner::new)
                .map(property(OldCpmGeoPinBanner.CREATIVE_ID, BANNERS_PERFORMANCE.CREATIVE_ID))
                .map(convertibleProperty(OldCpmGeoPinBanner.CREATIVE_STATUS_MODERATE, BANNERS_PERFORMANCE.STATUS_MODERATE,
                        OldBannerCreativeStatusModerate::fromSource, OldBannerCreativeStatusModerate::toSource))
                .map(property(OldCpmGeoPinBanner.PERMALINK_ID, BANNER_PERMALINKS.PERMALINK))
                .build();
    }
}
