package ru.yandex.direct.core.entity.banner.repository.old.mapper;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.banner.model.old.OldBannerCreativeStatusModerate;
import ru.yandex.direct.core.entity.banner.model.old.OldCpmIndoorBanner;
import ru.yandex.direct.dbschema.ppc.tables.records.BannersRecord;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplier;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplierBuilder;
import ru.yandex.direct.jooqmapperhelper.JooqUpdateBuilder;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.core.entity.banner.repository.old.mapper.CommonBannerMapperProvider.createBannersCommonUpdateBuilder;
import static ru.yandex.direct.core.entity.banner.repository.old.mapper.CommonBannerMapperProvider.getCommonBannerMapper;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS_PERFORMANCE;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;

@ParametersAreNonnullByDefault
@Deprecated
public class CpmIndoorBannerMapperProvider {

    private static final JooqMapperWithSupplier<OldCpmIndoorBanner> CPM_BANNER_MAPPER =
            createCpmIndoorBannerMapper();

    private CpmIndoorBannerMapperProvider() {
    }

    /**
     * @return {@link JooqMapperWithSupplier} для медийного indoor объявления {@link OldCpmIndoorBanner}.
     * @see CommonBannerMapperProvider
     */
    public static JooqMapperWithSupplier<OldCpmIndoorBanner> getCpmIndoorBannerMapper() {
        return CPM_BANNER_MAPPER;
    }

    /**
     * @param appliedChanges изменения моделей при обновлении
     * @return {@link JooqUpdateBuilder} для медийных indoor объявлений {@link OldCpmIndoorBanner}.
     */
    public static JooqUpdateBuilder<BannersRecord, OldCpmIndoorBanner> createCpmIndoorBannerUpdateBuilder(
            Collection<AppliedChanges<OldCpmIndoorBanner>> appliedChanges) {
        return createBannersCommonUpdateBuilder(appliedChanges);
    }

    private static JooqMapperWithSupplier<OldCpmIndoorBanner> createCpmIndoorBannerMapper() {
        return JooqMapperWithSupplierBuilder.builder(getCommonBannerMapper(), OldCpmIndoorBanner::new)
                .map(property(OldCpmIndoorBanner.CREATIVE_ID, BANNERS_PERFORMANCE.CREATIVE_ID))
                .map(convertibleProperty(OldCpmIndoorBanner.CREATIVE_STATUS_MODERATE, BANNERS_PERFORMANCE.STATUS_MODERATE,
                        OldBannerCreativeStatusModerate::fromSource, OldBannerCreativeStatusModerate::toSource))
                .build();
    }
}
