package ru.yandex.direct.core.entity.banner.repository.old.mapper;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.banner.model.old.OldBannerCreativeStatusModerate;
import ru.yandex.direct.core.entity.banner.model.old.OldCpmOutdoorBanner;
import ru.yandex.direct.dbschema.ppc.tables.records.BannersRecord;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplier;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplierBuilder;
import ru.yandex.direct.jooqmapperhelper.JooqUpdateBuilder;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.core.entity.banner.repository.old.mapper.CommonBannerMapperProvider.createBannersCommonUpdateBuilder;
import static ru.yandex.direct.core.entity.banner.repository.old.mapper.CommonBannerMapperProvider.getCommonBannerMapper;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS_PERFORMANCE;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;

@ParametersAreNonnullByDefault
@Deprecated
public class CpmOutdoorBannerMapperProvider {

    private static final JooqMapperWithSupplier<OldCpmOutdoorBanner> CPM_BANNER_MAPPER =
            createCpmOutdoorBannerMapper();

    private CpmOutdoorBannerMapperProvider() {
    }

    /**
     * @return {@link JooqMapperWithSupplier} для медийного outdoor объявления {@link OldCpmOutdoorBanner}.
     * @see CommonBannerMapperProvider
     */
    public static JooqMapperWithSupplier<OldCpmOutdoorBanner> getCpmOutdoorBannerMapper() {
        return CPM_BANNER_MAPPER;
    }

    /**
     * @param appliedChanges изменения моделей при обновлении
     * @return {@link JooqUpdateBuilder} для медийных outdoor объявлений {@link OldCpmOutdoorBanner}.
     */
    public static JooqUpdateBuilder<BannersRecord, OldCpmOutdoorBanner> createCpmOutdoorBannerUpdateBuilder(
            Collection<AppliedChanges<OldCpmOutdoorBanner>> appliedChanges) {
        return createBannersCommonUpdateBuilder(appliedChanges);
    }

    private static JooqMapperWithSupplier<OldCpmOutdoorBanner> createCpmOutdoorBannerMapper() {
        return JooqMapperWithSupplierBuilder.builder(getCommonBannerMapper(), OldCpmOutdoorBanner::new)
                .map(property(OldCpmOutdoorBanner.CREATIVE_ID, BANNERS_PERFORMANCE.CREATIVE_ID))
                .map(convertibleProperty(OldCpmOutdoorBanner.CREATIVE_STATUS_MODERATE, BANNERS_PERFORMANCE.STATUS_MODERATE,
                        OldBannerCreativeStatusModerate::fromSource, OldBannerCreativeStatusModerate::toSource))
                .build();
    }
}
