package ru.yandex.direct.core.entity.banner.repository.old.mapper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;

import javax.annotation.ParametersAreNonnullByDefault;

import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import ru.yandex.direct.common.TranslationService;
import ru.yandex.direct.core.entity.banner.BannerTranslations;
import ru.yandex.direct.core.entity.banner.model.old.DisplayHrefStatusModerate;
import ru.yandex.direct.core.entity.banner.model.old.OldDynamicBanner;
import ru.yandex.direct.core.entity.banner.model.old.StatusSitelinksModerate;
import ru.yandex.direct.dbschema.ppc.tables.records.BannersRecord;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplier;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplierBuilder;
import ru.yandex.direct.jooqmapperhelper.JooqUpdateBuilder;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.core.entity.banner.repository.old.mapper.CommonBannerMapperProvider.createBannersCommonUpdateBuilder;
import static ru.yandex.direct.core.entity.banner.repository.old.mapper.CommonBannerMapperProvider.getCommonBannerMapper;
import static ru.yandex.direct.core.entity.banner.repository.old.mapper.Constants.Opts.GEO_FLAG;
import static ru.yandex.direct.core.entity.banner.repository.old.mapper.Constants.Opts.NO_DISPLAY_HREF;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_DISPLAY_HREFS;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;
import static ru.yandex.direct.jooqmapper.read.ReaderBuilders.fromField;
import static ru.yandex.direct.jooqmapper.write.WriterBuilders.fromSupplier;

@Component
@ParametersAreNonnullByDefault
@Deprecated
public class DynamicBannerMapperProvider {

    private final JooqMapperWithSupplier<OldDynamicBanner> dynamicBannerMapper;

    public DynamicBannerMapperProvider(TranslationService translationService) {
        Supplier<String> localizedDynamicTitleSupplier = () -> translationService.translate(
                BannerTranslations.INSTANCE.dynamicTitle());

        this.dynamicBannerMapper =
                JooqMapperWithSupplierBuilder.builder(getCommonBannerMapper(), OldDynamicBanner::new)
                        .map(property(OldDynamicBanner.VCARD_ID, BANNERS.VCARD_ID))
                        .map(property(OldDynamicBanner.SITELINKS_SET_ID, BANNERS.SITELINKS_SET_ID))
                        .map(convertibleProperty(OldDynamicBanner.STATUS_SITELINKS_MODERATE,
                                BANNERS.STATUS_SITELINKS_MODERATE,
                                StatusSitelinksModerate::fromSource, StatusSitelinksModerate::toSource))
                        .map(property(OldDynamicBanner.BODY, BANNERS.BODY))
                        .readProperty(OldDynamicBanner.SHOW_DISPLAY_HREF, fromField(BANNERS.OPTS)
                                .by(opts -> !opts.contains(NO_DISPLAY_HREF)))
                        .map(property(OldDynamicBanner.DISPLAY_HREF, BANNER_DISPLAY_HREFS.DISPLAY_HREF))
                        .map(convertibleProperty(OldDynamicBanner.DISPLAY_HREF_STATUS_MODERATE,
                                BANNER_DISPLAY_HREFS.STATUS_MODERATE,
                                DisplayHrefStatusModerate::fromSource, DisplayHrefStatusModerate::toSource))
                        // в новых баннерах реализовано в BannerWithFixedTitleAddOperationTypeSupport
                        .writeField(BANNERS.TITLE, fromSupplier(localizedDynamicTitleSupplier))
                        .build();
    }

    /**
     * @return {@link JooqMapperWithSupplier} для динамиеских баннеров.
     * @see CommonBannerMapperProvider
     */
    public JooqMapperWithSupplier<OldDynamicBanner> getDynamicBannerMapper() {
        return dynamicBannerMapper;
    }

    public JooqUpdateBuilder<BannersRecord, OldDynamicBanner> createDynamicBannerUpdateBuilder(
            Collection<AppliedChanges<OldDynamicBanner>> appliedChanges) {
        JooqUpdateBuilder<BannersRecord, OldDynamicBanner> bannerUpdateBuilder =
                createBannersCommonUpdateBuilder(appliedChanges);

        bannerUpdateBuilder.processProperty(OldDynamicBanner.BODY, BANNERS.BODY);
        bannerUpdateBuilder.processProperty(OldDynamicBanner.VCARD_ID, BANNERS.VCARD_ID);
        bannerUpdateBuilder.processProperty(OldDynamicBanner.SITELINKS_SET_ID, BANNERS.SITELINKS_SET_ID);
        bannerUpdateBuilder
                .processProperty(OldDynamicBanner.STATUS_SITELINKS_MODERATE, BANNERS.STATUS_SITELINKS_MODERATE,
                        StatusSitelinksModerate::toSource);

        return bannerUpdateBuilder;
    }

    /**
     * Получает значение ppc.banners.opts из объекта баннера.
     * <p>
     * Значение opts основано на значениях нескольких полей баннера.
     *
     * @param banner баннер
     * @return значение ppc.banners.opts для записи в базу
     */
    public static String bannerOptsToDb(OldDynamicBanner banner) {
        List<String> opts = new ArrayList<>();
        if (!banner.getShowDisplayHref()) {
            opts.add(NO_DISPLAY_HREF);
        }
        if (banner.getGeoFlag()) {
            opts.add(GEO_FLAG);
        }
        return StringUtils.join(opts, ",");
    }

}
