package ru.yandex.direct.core.entity.banner.repository.old.mapper;

import java.util.Collection;
import java.util.function.Supplier;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.banner.model.ButtonAction;
import ru.yandex.direct.core.entity.banner.model.old.OldBannerButtonStatusModerate;
import ru.yandex.direct.core.entity.banner.model.old.OldBannerCreativeStatusModerate;
import ru.yandex.direct.core.entity.banner.model.old.OldImageBanner;
import ru.yandex.direct.core.entity.banner.model.old.OldImageCreativeBanner;
import ru.yandex.direct.core.entity.banner.model.old.OldImageHashBanner;
import ru.yandex.direct.core.entity.banner.model.old.StatusBannerLogoModerate;
import ru.yandex.direct.core.entity.banner.turbolanding.model.OldBannerTurboLandingStatusModerate;
import ru.yandex.direct.dbschema.ppc.tables.BannerButtons;
import ru.yandex.direct.dbschema.ppc.tables.records.BannersRecord;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplier;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplierBuilder;
import ru.yandex.direct.jooqmapperhelper.JooqUpdateBuilder;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.core.entity.banner.repository.old.mapper.CommonBannerMapperProvider.createBannersCommonUpdateBuilder;
import static ru.yandex.direct.core.entity.banner.repository.old.mapper.CommonBannerMapperProvider.getCommonBannerMapper;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS_PERFORMANCE;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_LOGOS;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_PERMALINKS;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_TURBOLANDINGS;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;

@ParametersAreNonnullByDefault
@Deprecated
public class ImageBannerMapperProvider {

    private static final JooqMapperWithSupplier<OldImageHashBanner> IMAGE_HASH_BANNER_MAPPER =
            createImageHashBannerMapper();

    private static final JooqMapperWithSupplier<OldImageCreativeBanner> IMAGE_CREATIVE_BANNER_MAPPER =
            createImageCreativeBannerMapper();

    private ImageBannerMapperProvider() {
    }

    /**
     * @return {@link JooqMapperWithSupplier} для графического объявления {@link OldImageHashBanner}.
     * @see CommonBannerMapperProvider
     */
    public static JooqMapperWithSupplier<OldImageHashBanner> getImageHashBannerMapper() {
        return IMAGE_HASH_BANNER_MAPPER;
    }

    /**
     * @return {@link JooqMapperWithSupplier} для графического объявления {@link OldImageCreativeBanner}.
     * @see CommonBannerMapperProvider
     */
    public static JooqMapperWithSupplier<OldImageCreativeBanner> getImageCreativeBannerMapper() {
        return IMAGE_CREATIVE_BANNER_MAPPER;
    }

    /**
     * @param appliedChanges изменения моделей при обновлении
     * @return {@link JooqUpdateBuilder} для графических объявлений {@link OldImageBanner}.
     */
    public static JooqUpdateBuilder<BannersRecord, OldImageBanner> createImageBannerUpdateBuilder(
            Collection<AppliedChanges<OldImageBanner>> appliedChanges) {
        return createBannersCommonUpdateBuilder(appliedChanges);
    }

    private static JooqMapperWithSupplier<OldImageHashBanner> createImageHashBannerMapper() {
        return createCommonMapperBuilder(OldImageHashBanner::new).build();
    }

    private static JooqMapperWithSupplier<OldImageCreativeBanner> createImageCreativeBannerMapper() {
        return createCommonMapperBuilder(OldImageCreativeBanner::new)
                .map(property(OldImageCreativeBanner.CREATIVE_ID, BANNERS_PERFORMANCE.CREATIVE_ID))
                .map(convertibleProperty(OldImageCreativeBanner.CREATIVE_STATUS_MODERATE,
                        BANNERS_PERFORMANCE.STATUS_MODERATE,
                        OldBannerCreativeStatusModerate::fromSource, OldBannerCreativeStatusModerate::toSource))
                .build();
    }

    private static <T extends OldImageBanner> JooqMapperWithSupplierBuilder<T> createCommonMapperBuilder(
            Supplier<T> supplier) {
        return JooqMapperWithSupplierBuilder.builder(getCommonBannerMapper(), supplier)
                .map(property(OldImageBanner.TITLE, BANNERS.TITLE))
                .map(property(OldImageBanner.TITLE_EXTENSION, BANNERS.TITLE_EXTENSION))
                .map(property(OldImageBanner.BODY, BANNERS.BODY))
                .map(property(OldImageBanner.TURBO_LANDING_ID, BANNER_TURBOLANDINGS.TL_ID))
                .map(convertibleProperty(OldImageBanner.TURBO_LANDING_STATUS_MODERATE,
                        BANNER_TURBOLANDINGS.STATUS_MODERATE,
                        OldBannerTurboLandingStatusModerate::fromSource, OldBannerTurboLandingStatusModerate::toSource))
                .map(property(OldImageBanner.PERMALINK_ID, BANNER_PERMALINKS.PERMALINK))
                .map(property(OldImageBanner.LOGO_IMAGE_HASH, BANNER_LOGOS.IMAGE_HASH))
                .map(convertibleProperty(OldImageBanner.LOGO_STATUS_MODERATE, BANNER_LOGOS.STATUS_MODERATE,
                        StatusBannerLogoModerate::fromSource, StatusBannerLogoModerate::toSource))
                .map(property(OldImageBanner.BUTTON_CAPTION, BannerButtons.BANNER_BUTTONS.CAPTION))
                .map(property(OldImageBanner.BUTTON_HREF, BannerButtons.BANNER_BUTTONS.HREF))
                .map(convertibleProperty(OldImageBanner.BUTTON_ACTION, BannerButtons.BANNER_BUTTONS.KEY,
                        ButtonAction::fromSource,
                        ButtonAction::toSource))
                .map(convertibleProperty(OldImageBanner.BUTTON_STATUS_MODERATE,
                        BannerButtons.BANNER_BUTTONS.STATUS_MODERATE,
                        OldBannerButtonStatusModerate::fromSource,
                        OldBannerButtonStatusModerate::toSource))
                ;
    }
}
