package ru.yandex.direct.core.entity.banner.repository.old.mapper;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.banner.model.old.Image;
import ru.yandex.direct.core.entity.banner.model.old.StatusImageModerate;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplier;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplierBuilder;

import static ru.yandex.direct.dbschema.ppc.tables.Images.IMAGES;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;

@ParametersAreNonnullByDefault
@Deprecated
public class ImageMapperProvider {

    private static final JooqMapperWithSupplier<Image> MAPPER = createMapper();

    private ImageMapperProvider() {
    }

    /**
     * @return {@link JooqMapperWithSupplier} для изображения графического объявления – {@link Image}.
     */
    public static JooqMapperWithSupplier<Image> getImageMapper() {
        return MAPPER;
    }

    private static JooqMapperWithSupplier<Image> createMapper() {
        return JooqMapperWithSupplierBuilder.builder(Image::new)
                .map(property(Image.ID, IMAGES.IMAGE_ID))
                .map(property(Image.CAMPAIGN_ID, IMAGES.CID))
                .map(property(Image.AD_GROUP_ID, IMAGES.PID))
                .map(property(Image.BANNER_ID, IMAGES.BID))
                .map(property(Image.IMAGE_HASH, IMAGES.IMAGE_HASH))
                .map(property(Image.IMAGE_TEXT, IMAGES.IMAGE_TEXT))
                .map(property(Image.DISCLAIMER_TEXT, IMAGES.DISCLAIMER_TEXT))
                .map(convertibleProperty(Image.STATUS_MODERATE, IMAGES.STATUS_MODERATE,
                        StatusImageModerate::fromSource, StatusImageModerate::toSource))
                .build();
    }
}
