package ru.yandex.direct.core.entity.banner.repository.old.mapper;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.function.Function;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;

import ru.yandex.direct.core.entity.banner.model.old.MobileContentPrimaryAction;
import ru.yandex.direct.core.entity.banner.model.old.OldMobileAppBanner;
import ru.yandex.direct.core.entity.banner.model.old.ReflectedAttribute;
import ru.yandex.direct.dbschema.ppc.tables.Banners;
import ru.yandex.direct.dbschema.ppc.tables.BannersMobileContent;
import ru.yandex.direct.dbschema.ppc.tables.records.BannersMobileContentRecord;
import ru.yandex.direct.dbschema.ppc.tables.records.BannersRecord;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplier;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplierBuilder;
import ru.yandex.direct.jooqmapperhelper.JooqUpdateBuilder;
import ru.yandex.direct.model.AppliedChanges;

import static java.util.stream.Collectors.joining;
import static java.util.stream.Collectors.toMap;
import static org.apache.commons.lang3.StringUtils.isBlank;
import static ru.yandex.direct.core.entity.banner.repository.old.mapper.CommonBannerMapperProvider.createBannersCommonUpdateBuilder;
import static ru.yandex.direct.core.entity.banner.repository.old.mapper.CommonBannerMapperProvider.getCommonBannerMapper;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS_MOBILE_CONTENT;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;
import static ru.yandex.direct.jooqmapper.write.WriterBuilders.fromProperty;

@ParametersAreNonnullByDefault
@Deprecated
public class MobileAppBannerMapperProvider {
    public static final JooqMapperWithSupplier<OldMobileAppBanner> MAPPER = createMapper();

    private MobileAppBannerMapperProvider() {
    }

    private static JooqMapperWithSupplier<OldMobileAppBanner> createMapper() {
        return JooqMapperWithSupplierBuilder.builder(getCommonBannerMapper(), OldMobileAppBanner::new)
                .map(property(OldMobileAppBanner.TITLE, BANNERS.TITLE))
                .map(property(OldMobileAppBanner.BODY, BANNERS.BODY))
                .writeField(BANNERS_MOBILE_CONTENT.BID, fromProperty(OldMobileAppBanner.ID))
                .map(convertibleProperty(OldMobileAppBanner.REFLECTED_ATTRS, BANNERS_MOBILE_CONTENT.REFLECTED_ATTRS,
                        MobileAppBannerMapperProvider::reflectedAttrsFromDbConverter,
                        MobileAppBannerMapperProvider::reflectedAttrsToDbConverter))
                .map(convertibleProperty(OldMobileAppBanner.PRIMARY_ACTION, BANNERS_MOBILE_CONTENT.PRIMARY_ACTION,
                        MobileContentPrimaryAction::fromSource, MobileContentPrimaryAction::toSource))
                .map(property(OldMobileAppBanner.IMPRESSION_URL, BANNERS_MOBILE_CONTENT.IMPRESSION_URL))
                .build();
    }

    public static JooqUpdateBuilder<BannersRecord, OldMobileAppBanner> createBannersUpdateBuilder(
            Collection<AppliedChanges<OldMobileAppBanner>> changes) {
        JooqUpdateBuilder<BannersRecord, OldMobileAppBanner> builder = createBannersCommonUpdateBuilder(changes);

        builder.processProperty(OldMobileAppBanner.TITLE, Banners.BANNERS.TITLE);
        builder.processProperty(OldMobileAppBanner.BODY, Banners.BANNERS.BODY);
        builder.processProperty(OldMobileAppBanner.DOMAIN, Banners.BANNERS.DOMAIN);

        return builder;
    }

    public static JooqUpdateBuilder<BannersMobileContentRecord, OldMobileAppBanner> createBannersMobileContentUpdateBuilder(
            Collection<AppliedChanges<OldMobileAppBanner>> changes) {
        JooqUpdateBuilder<BannersMobileContentRecord, OldMobileAppBanner> builder
                = new JooqUpdateBuilder<>(BannersMobileContent.BANNERS_MOBILE_CONTENT.BID, changes);

        builder.processProperty(OldMobileAppBanner.PRIMARY_ACTION,
                BannersMobileContent.BANNERS_MOBILE_CONTENT.PRIMARY_ACTION,
                MobileContentPrimaryAction::toSource);
        builder.processProperty(OldMobileAppBanner.REFLECTED_ATTRS,
                BannersMobileContent.BANNERS_MOBILE_CONTENT.REFLECTED_ATTRS,
                MobileAppBannerMapperProvider::reflectedAttrsToDbConverter);
        builder.processProperty(OldMobileAppBanner.IMPRESSION_URL,
                BannersMobileContent.BANNERS_MOBILE_CONTENT.IMPRESSION_URL);
        return builder;
    }

    private static String reflectedAttrsToDbConverter(@Nullable Map<ReflectedAttribute, Boolean> attrs) {
        return attrs == null ? "" :
                attrs.entrySet().stream()
                        .filter(Map.Entry::getValue)
                        .map(e -> e.getKey().getTypedValue())
                        .collect(joining(","));
    }

    private static Map<ReflectedAttribute, Boolean> reflectedAttrsFromDbConverter(String value) {
        if (isBlank(value)) {
            return convertToMap(EnumSet.allOf(ReflectedAttribute.class), false);
        }

        EnumSet<ReflectedAttribute> on = EnumSet.copyOf(
                StreamEx.split(value, ",")
                        .map(ReflectedAttribute::fromTypedValue)
                        .toSet());
        Map<ReflectedAttribute, Boolean> result = convertToMap(on, true);
        result.putAll(convertToMap(EnumSet.complementOf(on), false));
        return result;
    }

    private static Map<ReflectedAttribute, Boolean> convertToMap(EnumSet<ReflectedAttribute> keys, Boolean value) {
        return keys.stream().collect(toMap(Function.identity(), attr -> value));
    }
}
