package ru.yandex.direct.core.entity.banner.repository.old.mapper;

import java.util.Collection;
import java.util.function.Supplier;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.common.TranslationService;
import ru.yandex.direct.core.entity.banner.BannerTranslations;
import ru.yandex.direct.core.entity.banner.model.old.OldBannerCreativeStatusModerate;
import ru.yandex.direct.core.entity.banner.model.old.OldPerformanceBanner;
import ru.yandex.direct.dbschema.ppc.tables.records.BannersRecord;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplier;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplierBuilder;
import ru.yandex.direct.jooqmapperhelper.JooqUpdateBuilder;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.core.entity.banner.repository.old.mapper.CommonBannerMapperProvider.createBannersCommonUpdateBuilder;
import static ru.yandex.direct.core.entity.banner.repository.old.mapper.CommonBannerMapperProvider.getCommonBannerMapper;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS;
import static ru.yandex.direct.dbschema.ppc.tables.BannersPerformance.BANNERS_PERFORMANCE;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;
import static ru.yandex.direct.jooqmapper.write.WriterBuilders.fromSupplier;

@Component
@ParametersAreNonnullByDefault
@Deprecated
public class PerformanceBannerMapperProvider {

    private final JooqMapperWithSupplier<OldPerformanceBanner> performanceBannerMapper;

    public PerformanceBannerMapperProvider(TranslationService translationService) {
        Supplier<String> localizedPerformanceTitleSupplier = () -> translationService.translate(
                BannerTranslations.INSTANCE.performanceTitle());
        Supplier<String> localizedPerformanceBodySupplier = () -> translationService.translate(
                BannerTranslations.INSTANCE.performanceBody());

        this.performanceBannerMapper =
                JooqMapperWithSupplierBuilder.builder(getCommonBannerMapper(), OldPerformanceBanner::new)
                        .map(property(OldPerformanceBanner.CREATIVE_ID, BANNERS_PERFORMANCE.CREATIVE_ID))
                        .map(convertibleProperty(OldPerformanceBanner.CREATIVE_STATUS_MODERATE,
                                BANNERS_PERFORMANCE.STATUS_MODERATE,
                                OldBannerCreativeStatusModerate::fromSource, OldBannerCreativeStatusModerate::toSource))
                        // в новых баннерах реализовано в BannerWithFixedTitleAddOperationTypeSupport
                        .writeField(BANNERS.TITLE, fromSupplier(localizedPerformanceTitleSupplier))
                        // в новых баннерах реализовано в BannerWithFixedBodyAddOperationTypeSupport
                        .writeField(BANNERS.BODY, fromSupplier(localizedPerformanceBodySupplier))
                        .build();
    }

    /**
     * @return {@link JooqMapperWithSupplier} для performance баннеров
     */
    public JooqMapperWithSupplier<OldPerformanceBanner> getPerformanceBannerMapper() {
        return performanceBannerMapper;
    }

    /**
     * @param appliedChanges изменения моделей при обновлении
     * @return {@link JooqUpdateBuilder} для performance баннеров
     */
    public JooqUpdateBuilder<BannersRecord, OldPerformanceBanner> createPerformanceBannerUpdateBuilder(
            Collection<AppliedChanges<OldPerformanceBanner>> appliedChanges) {
        return createBannersCommonUpdateBuilder(appliedChanges);
    }
}
