package ru.yandex.direct.core.entity.banner.repository.old.mapper;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import org.apache.commons.lang3.StringUtils;

import ru.yandex.direct.core.entity.banner.model.ButtonAction;
import ru.yandex.direct.core.entity.banner.model.old.DisplayHrefStatusModerate;
import ru.yandex.direct.core.entity.banner.model.old.OldBannerButtonStatusModerate;
import ru.yandex.direct.core.entity.banner.model.old.OldTextBanner;
import ru.yandex.direct.core.entity.banner.model.old.StatusBannerLogoModerate;
import ru.yandex.direct.core.entity.banner.model.old.StatusSitelinksModerate;
import ru.yandex.direct.core.entity.banner.turbolanding.model.OldBannerTurboLandingStatusModerate;
import ru.yandex.direct.dbschema.ppc.tables.BannerButtons;
import ru.yandex.direct.dbschema.ppc.tables.Banners;
import ru.yandex.direct.dbschema.ppc.tables.records.BannersRecord;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplier;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplierBuilder;
import ru.yandex.direct.jooqmapperhelper.JooqUpdateBuilder;
import ru.yandex.direct.model.AppliedChanges;

import static org.apache.commons.lang3.StringUtils.isEmpty;
import static ru.yandex.direct.common.jooqmapperex.ReaderWriterBuildersEx.booleanProperty;
import static ru.yandex.direct.core.entity.banner.repository.old.mapper.CommonBannerMapperProvider.createBannersCommonUpdateBuilder;
import static ru.yandex.direct.core.entity.banner.repository.old.mapper.CommonBannerMapperProvider.getCommonBannerMapper;
import static ru.yandex.direct.core.entity.banner.repository.old.mapper.Constants.Opts.GEO_FLAG;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_DISPLAY_HREFS;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_LOGOS;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_PERMALINKS;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_PHONES;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_TURBOLANDINGS;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_TURBO_GALLERIES;
import static ru.yandex.direct.dbschema.ppc.tables.BannersPerformance.BANNERS_PERFORMANCE;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;
import static ru.yandex.direct.jooqmapper.write.WriterBuilders.fromProperty;

@ParametersAreNonnullByDefault
@Deprecated
public class TextBannerMapperProvider {
    private static final String OPTS_SEPARATOR = ",";
    private static final Splitter OPTS_SPLITTER = Splitter.on(OPTS_SEPARATOR).omitEmptyStrings();

    private static final JooqMapperWithSupplier<OldTextBanner> MAPPER = createMapper();

    private TextBannerMapperProvider() {
    }

    /**
     * @return {@link JooqMapperWithSupplier} для текстовых баннеров.
     * @see CommonBannerMapperProvider
     */
    public static JooqMapperWithSupplier<OldTextBanner> getTextBannerMapper() {
        return MAPPER;
    }

    public static JooqUpdateBuilder<BannersRecord, OldTextBanner> createTextBannerUpdateBuilder(
            Collection<AppliedChanges<OldTextBanner>> appliedChanges) {
        return createUpdateBuilder(appliedChanges);
    }

    /**
     * Обновить в наборе параметров баннера геофлаг
     */
    public static String updateGeoFlagInOpts(String opts, Boolean geoFlag) {
        Set<String> flags = new HashSet<>();
        if (!isEmpty(opts)) {
            Iterables.addAll(flags, OPTS_SPLITTER.split(opts));
        }
        if (geoFlag) {
            flags.add(GEO_FLAG);
        } else {
            flags.remove(GEO_FLAG);
        }
        return StringUtils.join(flags, OPTS_SEPARATOR);
    }

    private static JooqMapperWithSupplier<OldTextBanner> createMapper() {
        return JooqMapperWithSupplierBuilder.builder(getCommonBannerMapper(), OldTextBanner::new)
                .map(property(OldTextBanner.VCARD_ID, BANNERS.VCARD_ID))
                .map(property(OldTextBanner.SITELINKS_SET_ID, BANNERS.SITELINKS_SET_ID))
                .map(convertibleProperty(OldTextBanner.STATUS_SITELINKS_MODERATE, BANNERS.STATUS_SITELINKS_MODERATE,
                        StatusSitelinksModerate::fromSource, StatusSitelinksModerate::toSource))
                .map(property(OldTextBanner.TITLE, BANNERS.TITLE))
                .map(convertibleProperty(OldTextBanner.TITLE_EXTENSION, BANNERS.TITLE_EXTENSION,
                        BannerMappings::titleExtensionFromDb, s -> s))
                .map(property(OldTextBanner.BODY, BANNERS.BODY))
                .map(property(OldTextBanner.DISPLAY_HREF, BANNER_DISPLAY_HREFS.DISPLAY_HREF))
                .map(convertibleProperty(OldTextBanner.DISPLAY_HREF_STATUS_MODERATE, BANNER_DISPLAY_HREFS.STATUS_MODERATE,
                        DisplayHrefStatusModerate::fromSource, DisplayHrefStatusModerate::toSource))
                .map(property(OldTextBanner.CREATIVE_ID, BANNERS_PERFORMANCE.CREATIVE_ID))
                .map(property(OldTextBanner.TURBO_GALLERY_HREF, BANNER_TURBO_GALLERIES.TURBO_GALLERY_HREF))
                .map(property(OldTextBanner.TURBO_LANDING_ID, BANNER_TURBOLANDINGS.TL_ID))
                .map(convertibleProperty(OldTextBanner.TURBO_LANDING_STATUS_MODERATE, BANNER_TURBOLANDINGS.STATUS_MODERATE,
                        OldBannerTurboLandingStatusModerate::fromSource, OldBannerTurboLandingStatusModerate::toSource))
                .map(property(OldTextBanner.PERMALINK_ID, BANNER_PERMALINKS.PERMALINK))
                .map(property(OldTextBanner.PHONE_ID, BANNER_PHONES.CLIENT_PHONE_ID))
                .map(booleanProperty(OldTextBanner.PREFER_V_CARD_OVER_PERMALINK, BANNER_PERMALINKS.PREFER_VCARD_OVER_PERMALINK))
                .map(property(OldTextBanner.LOGO_IMAGE_HASH, BANNER_LOGOS.IMAGE_HASH))
                .map(convertibleProperty(OldTextBanner.LOGO_STATUS_MODERATE, BANNER_LOGOS.STATUS_MODERATE,
                        StatusBannerLogoModerate::fromSource, StatusBannerLogoModerate::toSource))
                .map(property(OldTextBanner.BUTTON_CAPTION, BannerButtons.BANNER_BUTTONS.CAPTION))
                .map(property(OldTextBanner.BUTTON_HREF, BannerButtons.BANNER_BUTTONS.HREF))
                .map(convertibleProperty(OldTextBanner.BUTTON_ACTION, BannerButtons.BANNER_BUTTONS.KEY,
                        ButtonAction::fromSource,
                        ButtonAction::toSource))
                .map(convertibleProperty(OldTextBanner.BUTTON_STATUS_MODERATE,
                        BannerButtons.BANNER_BUTTONS.STATUS_MODERATE,
                        OldBannerButtonStatusModerate::fromSource,
                        OldBannerButtonStatusModerate::toSource))

                .writeField(BANNER_TURBO_GALLERIES.BID, fromProperty(OldTextBanner.ID))
                .build();
    }

    private static JooqUpdateBuilder<BannersRecord, OldTextBanner> createUpdateBuilder(
            Collection<AppliedChanges<OldTextBanner>> appliedChanges) {
        JooqUpdateBuilder<BannersRecord, OldTextBanner> bannerUpdateBuilder =
                createBannersCommonUpdateBuilder(appliedChanges);

        bannerUpdateBuilder.processProperty(OldTextBanner.TITLE, Banners.BANNERS.TITLE);
        bannerUpdateBuilder.processProperty(OldTextBanner.TITLE_EXTENSION, Banners.BANNERS.TITLE_EXTENSION);
        bannerUpdateBuilder.processProperty(OldTextBanner.BODY, Banners.BANNERS.BODY);
        bannerUpdateBuilder.processProperty(OldTextBanner.VCARD_ID, Banners.BANNERS.VCARD_ID);
        bannerUpdateBuilder.processProperty(OldTextBanner.SITELINKS_SET_ID, Banners.BANNERS.SITELINKS_SET_ID);
        bannerUpdateBuilder
                .processProperty(OldTextBanner.STATUS_SITELINKS_MODERATE, Banners.BANNERS.STATUS_SITELINKS_MODERATE,
                        StatusSitelinksModerate::toSource);

        return bannerUpdateBuilder;
    }
}
