package ru.yandex.direct.core.entity.banner.repository.old.mapper.turbolanding;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.common.jooqmapper.OldJooqMapperWithSupplier;
import ru.yandex.direct.common.util.RepositoryUtils;
import ru.yandex.direct.core.entity.turbolanding.model.StatusModerateForCpa;
import ru.yandex.direct.core.entity.turbolanding.model.StatusPostModerate;
import ru.yandex.direct.core.entity.turbolanding.model.TurboLanding;
import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplier;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplierBuilder;

import static ru.yandex.direct.common.jooqmapperex.ReaderWriterBuildersEx.booleanProperty;
import static ru.yandex.direct.dbschema.ppc.Tables.TURBOLANDINGS;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;

@ParametersAreNonnullByDefault
@Deprecated
public class TurboLandingMapperProvider {

    private static final JooqMapperWithSupplier<TurboLanding> MAPPER = createMapper();

    private TurboLandingMapperProvider() {
    }

    /**
     * @return {@link OldJooqMapperWithSupplier} для не привязанных турболендингов.
     */
    public static JooqMapperWithSupplier<TurboLanding> getTurboLandingMapper() {
        return MAPPER;
    }


    /*
     * Общие для всех турболендингов поля
     */

    public static <T extends TurboLanding> JooqMapper<T> getCommonMapper() {
        return JooqMapperBuilder.<T>builder()
                .map(property(T.ID, TURBOLANDINGS.TL_ID))
                .map(property(T.CLIENT_ID, TURBOLANDINGS.CLIENT_ID))
                .map(convertibleProperty(T.URL, TURBOLANDINGS.HREF,
                        RepositoryUtils::nullableStringFromNotNullDbField,
                        RepositoryUtils::nullableStringToNotNullDbField))
                .map(property(T.NAME, TURBOLANDINGS.NAME))
                .map(property(T.METRIKA_COUNTERS, TURBOLANDINGS.METRIKA_COUNTERS_JSON))
                .map(booleanProperty(T.IS_CHANGED, TURBOLANDINGS.IS_CHANGED))
                .map(property(T.VERSION, TURBOLANDINGS.VERSION))
                .map(property(T.LAST_MODERATED_VERSION, TURBOLANDINGS.LAST_MODERATED_VERSION))
                .map(property(T.PREVIEW_HREF, TURBOLANDINGS.PREVIEW_HREF))
                .map(convertibleProperty(T.TURBO_SITE_HREF, TURBOLANDINGS.TURBO_SITE_HREF,
                        RepositoryUtils::nullableStringFromNotNullDbField,
                        RepositoryUtils::nullableStringToNotNullDbField))
                .map(convertibleProperty(T.IS_CPA_MODERATION_REQUIRED, TURBOLANDINGS.IS_CPA_MODERATION_REQUIRED,
                        RepositoryUtils::booleanFromLong, RepositoryUtils::nullSafeBooleanToLong))
                .map(convertibleProperty(T.STATUS_MODERATE_FOR_CPA, TURBOLANDINGS.STATUS_MODERATE_FOR_CPA,
                        StatusModerateForCpa::fromSource, StatusModerateForCpa::toSource))
                .map(convertibleProperty(T.STATUS_POST_MODERATE, TURBOLANDINGS.STATUS_POST_MODERATE,
                        StatusPostModerate::fromSource, StatusPostModerate::toSource))
                .map(property(T.PRESET, TURBOLANDINGS.PRESET))
                .build();
    }

    private static JooqMapperWithSupplier<TurboLanding> createMapper() {
        return JooqMapperWithSupplierBuilder.builder(getCommonMapper(), TurboLanding::new).build();
    }

}
