package ru.yandex.direct.core.entity.banner.repository.old.type;

import java.util.Collection;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;

import ru.yandex.direct.core.entity.banner.model.old.OldBanner;
import ru.yandex.direct.core.entity.banner.repository.old.mapper.BannerMappings;
import ru.yandex.direct.core.entity.banner.repository.old.mapper.CommonBannerMapperProvider;
import ru.yandex.direct.dbschema.ppc.tables.records.BannersRecord;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapperhelper.JooqUpdateBuilder;
import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.model.ModelProperty;

import static java.util.Collections.singletonList;
import static ru.yandex.direct.dbschema.ppc.tables.Banners.BANNERS;

@ParametersAreNonnullByDefault
@Deprecated
abstract class OldAbstractBannerRepositoryTypeSupport<B extends OldBanner> implements OldBannerRepositoryTypeSupport<B> {

    private final DslContextProvider dslContextProvider;
    private final ShardHelper shardHelper;

    OldAbstractBannerRepositoryTypeSupport(DslContextProvider dslContextProvider,
                                           ShardHelper shardHelper) {
        this.dslContextProvider = dslContextProvider;
        this.shardHelper = shardHelper;
    }

    /**
     * @inheritDoc Разделён на три этапа, типичных для операций записи:
     * <ol>
     * <li>{@link #beforeBannersAdd}</li>
     * <li>{@link #addBannersToDb}</li>
     * <li>{@link #afterBannersAdded}</li></ol>
     * Каждый из них необязателен к переопределению.
     * Если же для каких-то типов такое разделение операции не подходит,
     * метод стоит переопределить.
     */
    @Override
    public void add(int shard, Collection<B> banners) {
        DSLContext context = dslContext(shard);

        beforeBannersAdd(shard, banners);
        addBannersToDb(banners, context);
        afterBannersAdded(banners, context);
    }

    /**
     * Подготовить связанные сущности к добавлению баннеров.
     *
     * @param shard   шард
     * @param banners баннеры
     */
    void beforeBannersAdd(int shard, Collection<B> banners) {
    }

    /**
     * Разложить модели в базу, используя маппинги для соответствующего типа.
     *
     * @param banners    сохраняемые модели
     * @param dslContext DSL контекст Jooq
     */
    void addBannersToDb(Collection<B> banners, DSLContext dslContext) {
    }

    /**
     * Обновить связанные сущности после добавления баннеров.
     *
     * @param banners    баннеры
     * @param dslContext DSL контекст Jooq
     */
    void afterBannersAdded(Collection<B> banners, DSLContext dslContext) {
    }

    /**
     * @param shard          шард
     * @param appliedChanges список изменений баннеров
     * @inheritDoc Общая реализация обновления geoFlag. Специфика типов
     * учитывается путём переопределения методов {@link #getPropertiesForOpts}
     * и {@link #optsToDb} при необходимости.
     */
    public void updateGeoFlag(int shard, Collection<AppliedChanges<B>> appliedChanges) {
        JooqUpdateBuilder<BannersRecord, B> updateBuilder =
                new JooqUpdateBuilder<>(BANNERS.BID, appliedChanges);

        updateBuilder.processProperties(getPropertiesForOpts(), BANNERS.OPTS, this::optsToDb);

        updateBuilder.processProperty(OldBanner.STATUS_BS_SYNCED, BANNERS.STATUS_BS_SYNCED,
                BannerMappings::statusBsSyncedToDb);
        updateBuilder.processProperty(OldBanner.LAST_CHANGE, BANNERS.LAST_CHANGE);

        dslContext(shard)
                .update(BANNERS)
                .set(updateBuilder.getValues())
                .where(BANNERS.BID.in(updateBuilder.getChangedIds()))
                .execute();
    }

    /**
     * @return Получить список свойств, которые заносятся в поле
     * {@link ru.yandex.direct.dbschema.ppc.tables.Banners#OPTS}
     * для баннеров данного типа.
     */
    @SuppressWarnings("squid:S1452")
    List<ModelProperty<? super B, ?>> getPropertiesForOpts() {
        return singletonList(OldBanner.GEO_FLAG);
    }

    /**
     * @see CommonBannerMapperProvider#bannerOptsToDb
     */
    String optsToDb(B banner) {
        return CommonBannerMapperProvider.bannerOptsToDb(banner.getGeoFlag());
    }

    DSLContext dslContext(int shard) {
        return dslContextProvider.ppc(shard);
    }

    ShardHelper shardHelper() {
        return shardHelper;
    }
}
