package ru.yandex.direct.core.entity.banner.repository.old.type;

import java.util.Collection;
import java.util.stream.Stream;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.old.OldBannerType;
import ru.yandex.direct.core.entity.banner.model.old.OldContentPromotionBanner;
import ru.yandex.direct.core.entity.domain.service.OldBannerAggregatorDomainsService;
import ru.yandex.direct.dbschema.ppc.tables.Banners;
import ru.yandex.direct.dbschema.ppc.tables.BannersContentPromotion;
import ru.yandex.direct.dbschema.ppc.tables.records.BannersContentPromotionRecord;
import ru.yandex.direct.dbschema.ppc.tables.records.BannersRecord;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplier;
import ru.yandex.direct.jooqmapperhelper.InsertHelper;
import ru.yandex.direct.jooqmapperhelper.JooqUpdateBuilder;
import ru.yandex.direct.model.AppliedChanges;

import static java.util.stream.Collectors.toList;
import static ru.yandex.direct.core.entity.banner.repository.old.mapper.ContentPromotionBannerMapperProvider.createBannersContentPromotionUpdateBuilder;
import static ru.yandex.direct.core.entity.banner.repository.old.mapper.ContentPromotionBannerMapperProvider.createBannersUpdateBuilder;
import static ru.yandex.direct.core.entity.banner.repository.old.mapper.ContentPromotionBannerMapperProvider.getContentPromotionBannerMapper;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS_CONTENT_PROMOTION;

/**
 * Реализация {@link OldBannerRepositoryTypeSupport} для объявлений продвижения контента.
 */
@Component
@ParametersAreNonnullByDefault
@Deprecated // см. ru.yandex.direct.core.entity.banner.type.contentpromo
public class OldBannerRepositoryContentPromotionTypeSupport extends
        OldAbstractBannerRepositoryTypeSupport<OldContentPromotionBanner> {

    private final OldBannerAggregatorDomainsService aggregatorDomainsService;

    private final JooqMapperWithSupplier<OldContentPromotionBanner> bannerMapper =
            getContentPromotionBannerMapper();

    private final Collection<Field<?>> allFields;

    public OldBannerRepositoryContentPromotionTypeSupport(DslContextProvider dslContextProvider,
                                                          ShardHelper shardHelper,
                                                          OldBannerAggregatorDomainsService aggregatorDomainsService) {
        super(dslContextProvider, shardHelper);

        this.aggregatorDomainsService = aggregatorDomainsService;

        allFields = Stream.of(bannerMapper.getFieldsToRead())
                .flatMap(Collection::stream)
                .collect(toList());
    }

    @Override
    public OldBannerType getType() {
        return OldBannerType.CONTENT_PROMOTION;
    }

    @Override
    public Collection<Field<?>> getAllFields() {
        return allFields;
    }

    @Override
    public void addBannersToDb(Collection<OldContentPromotionBanner> banners, DSLContext context) {
        context.transaction(ctx -> {
            DSLContext dslContext = DSL.using(ctx);

            new InsertHelper<>(dslContext, Banners.BANNERS)
                    .addAll(bannerMapper, banners)
                    .executeIfRecordsAdded();

            new InsertHelper<>(dslContext, BannersContentPromotion.BANNERS_CONTENT_PROMOTION)
                    .addAll(bannerMapper, banners)
                    .executeIfRecordsAdded();
        });
    }

    @Override
    public void afterBannersAdded(Collection<OldContentPromotionBanner> banners, DSLContext dslContext) {
        aggregatorDomainsService.updateAggregatorDomains(dslContext, banners);
    }

    @Override
    public void update(int shard, Collection<AppliedChanges<OldContentPromotionBanner>> appliedChanges) {
        JooqUpdateBuilder<BannersRecord, OldContentPromotionBanner> bannersBuilder =
                createBannersUpdateBuilder(appliedChanges);
        JooqUpdateBuilder<BannersContentPromotionRecord, OldContentPromotionBanner> bannersContentPromotionBuilder
                = createBannersContentPromotionUpdateBuilder(appliedChanges);

        final DSLContext context = dslContext(shard);
        context.transaction(ctx -> {
            DSL.using(ctx)
                    .update(BANNERS)
                    .set(bannersBuilder.getValues())
                    .where(BANNERS.BID.in(bannersBuilder.getChangedIds()))
                    .execute();

            DSL.using(ctx)
                    .update(BANNERS_CONTENT_PROMOTION)
                    .set(bannersContentPromotionBuilder.getValues())
                    .where(BANNERS_CONTENT_PROMOTION.BID.in(bannersContentPromotionBuilder.getChangedIds()))
                    .execute();

            aggregatorDomainsService.updateAggregatorDomains(ctx, appliedChanges);
        });
    }

    @Override
    public OldContentPromotionBanner createBannerFromRecord(Record record) {
        return bannerMapper.fromDb(record);
    }

    @Override
    public Stream<OldContentPromotionBanner> createBannersFromRecordsWithAdditionsAttached(int shard,
                                                                                           Collection<Record> records) {
        return records.stream().map(this::createBannerFromRecord);
    }
}
