package ru.yandex.direct.core.entity.banner.repository.old.type;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.impl.DSL;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.old.OldBannerCreative;
import ru.yandex.direct.core.entity.banner.model.old.OldBannerPixel;
import ru.yandex.direct.core.entity.banner.model.old.OldBannerType;
import ru.yandex.direct.core.entity.banner.model.old.OldCpmAudioBanner;
import ru.yandex.direct.core.entity.banner.repository.old.OldBannerMeasurersRepository;
import ru.yandex.direct.core.entity.banner.repository.old.OldBannerPixelsRepository;
import ru.yandex.direct.core.entity.banner.repository.old.container.BannerPixelsUpdateContainer;
import ru.yandex.direct.core.entity.banner.repository.old.container.InsertUpdateDeleteContainer;
import ru.yandex.direct.core.entity.banner.turbolanding.model.OldBannerTurboLandingParams;
import ru.yandex.direct.dbschema.ppc.tables.Banners;
import ru.yandex.direct.dbschema.ppc.tables.records.BannersRecord;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplier;
import ru.yandex.direct.jooqmapperhelper.InsertHelper;
import ru.yandex.direct.jooqmapperhelper.JooqUpdateBuilder;
import ru.yandex.direct.model.AppliedChanges;

import static java.util.Collections.emptyList;
import static java.util.stream.Collectors.toList;
import static org.apache.commons.lang3.ObjectUtils.defaultIfNull;
import static org.springframework.util.CollectionUtils.isEmpty;
import static ru.yandex.direct.core.entity.banner.repository.old.mapper.BannerCreativeMapperProvider.getBannerCreativeMapper;
import static ru.yandex.direct.core.entity.banner.repository.old.mapper.CpmAudioBannerMapperProvider.createCpmAudioBannerUpdateBuilder;
import static ru.yandex.direct.core.entity.banner.repository.old.mapper.CpmAudioBannerMapperProvider.getCpmAudioBannerMapper;
import static ru.yandex.direct.core.entity.banner.repository.old.mapper.turbolanding.BannerTurboLandingParamsMapperProvider.getBannerTurboLandingParamsMapper;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS;
import static ru.yandex.direct.utils.FunctionalUtils.listToSet;

/**
 * Реализация {@link OldBannerRepositoryTypeSupport} для медийных аудио баннеров.
 */
@Component
@ParametersAreNonnullByDefault
@Deprecated
public class OldBannerRepositoryCpmAudioTypeSupport extends OldAbstractBannerRepositoryTypeSupport<OldCpmAudioBanner> {

    private final OldBannerWithCreativeSupport bannerWithCreativeSupport;
    private final OldBannerPixelsRepository bannerPixelsRepository;
    private final OldBannerWithPixelsSupport bannerWithPixelsSupport;
    private final OldBannerWithTurboLandingSupport bannerWithTurboLandingSupport;
    private final OldBannerWithMeasurersSupport bannerWithMeasurersSupport;
    private final OldBannerMeasurersRepository bannerMeasurersRepository;

    private final JooqMapperWithSupplier<OldCpmAudioBanner> cpmAudioBannerMapper = getCpmAudioBannerMapper();
    private final JooqMapperWithSupplier<OldBannerCreative> bannerCreativeMapper = getBannerCreativeMapper();
    private final JooqMapperWithSupplier<OldBannerTurboLandingParams> bannerTurboLandingParamsMapper = getBannerTurboLandingParamsMapper();

    private final Collection<Field<?>> allFields;

    @Autowired
    OldBannerRepositoryCpmAudioTypeSupport(
            DslContextProvider dslContextProvider,
            ShardHelper shardHelper,
            OldBannerWithCreativeSupport bannerWithCreativeSupport,
            OldBannerPixelsRepository bannerPixelsRepository,
            OldBannerWithPixelsSupport bannerWithPixelsSupport,
            OldBannerWithTurboLandingSupport bannerWithTurboLandingSupport,
            OldBannerWithMeasurersSupport bannerWithMeasurersSupport, OldBannerMeasurersRepository bannerMeasurersRepository) {
        super(dslContextProvider, shardHelper);

        this.bannerWithCreativeSupport = bannerWithCreativeSupport;
        this.bannerPixelsRepository = bannerPixelsRepository;
        this.bannerWithPixelsSupport = bannerWithPixelsSupport;
        this.bannerWithTurboLandingSupport = bannerWithTurboLandingSupport;
        this.bannerWithMeasurersSupport = bannerWithMeasurersSupport;
        this.bannerMeasurersRepository = bannerMeasurersRepository;

        allFields = Stream.of(cpmAudioBannerMapper, bannerCreativeMapper)
                .map(JooqMapper::getFieldsToRead)
                .flatMap(Collection::stream)
                .collect(toList());
    }

    @Override
    public OldBannerType getType() {
        return OldBannerType.CPM_AUDIO;
    }

    @Override
    public Collection<Field<?>> getAllFields() {
        return allFields;
    }

    @Override
    public void update(int shard, Collection<AppliedChanges<OldCpmAudioBanner>> appliedChanges) {
        InsertUpdateDeleteContainer<OldBannerCreative> bannerCreativesUpdateContainer =
                bannerWithCreativeSupport.prepareCreativesUpdateContainer(appliedChanges);

        Collection<OldBannerCreative> creativesToUpdate = bannerCreativesUpdateContainer.getModelsToUpdate();

        // подготовка пикселей к изменению
        BannerPixelsUpdateContainer bannerPixelsUpdateContainer = bannerWithPixelsSupport.preparePixelsUpdateContainer(appliedChanges);
        List<OldBannerPixel> bannersPixelsToAdd = bannerPixelsUpdateContainer.getBannerPixelsToAdd();
        Map<Long, List<String>> bannersPixelsToDelete = bannerPixelsUpdateContainer.getBannerPixelsToDelete();

        JooqUpdateBuilder<BannersRecord, OldCpmAudioBanner> bannerUpdateBuilder = createCpmAudioBannerUpdateBuilder(appliedChanges);

        dslContext(shard).transaction(ctx -> {
            DSL.using(ctx)
                    .update(BANNERS)
                    .set(bannerUpdateBuilder.getValues())
                    .where(Banners.BANNERS.BID.in(bannerUpdateBuilder.getChangedIds()))
                    .execute();

            bannerWithCreativeSupport.updateCreatives(ctx, creativesToUpdate);

            bannerPixelsRepository.addBannerPixels(bannersPixelsToAdd, DSL.using(ctx));
            bannerPixelsRepository.deleteBannerPixels(bannersPixelsToDelete, DSL.using(ctx));

            bannerWithTurboLandingSupport.updateTurbolandings(appliedChanges, ctx);
            bannerWithTurboLandingSupport.updateTurbolandingParams(appliedChanges, ctx);

            bannerWithMeasurersSupport.updateMeasurers(appliedChanges, ctx);
        });
    }

    @Override
    public void add(int shard, Collection<OldCpmAudioBanner> banners) {
        // prepare
        bannerWithCreativeSupport.addBannerCreatives(banners, shard);
        bannerWithMeasurersSupport.addMeasurers(banners, shard);
        DSLContext dslContext = dslContext(shard);

        // write
        InsertHelper.saveModelObjectsToDbTable(dslContext, BANNERS, cpmAudioBannerMapper, banners);
        addBannerToBannerPixelsTable(banners, dslContext);

        bannerWithTurboLandingSupport.updateAfterBannersAdded(banners, dslContext);
    }

    private void addBannerToBannerPixelsTable(Collection<OldCpmAudioBanner> banners, DSLContext context) {
        List<OldBannerPixel> bannersAllPixelsList = banners
                .stream()
                .filter(b -> !isEmpty(b.getPixels()))
                .map(OldBannerPixelsRepository::extractBannerPixels)
                .flatMap(List::stream)
                .collect(toList());
        bannerPixelsRepository.addBannerPixels(bannersAllPixelsList, context);
    }

    @Override
    public OldCpmAudioBanner createBannerFromRecord(Record record) {
        OldCpmAudioBanner banner = cpmAudioBannerMapper.fromDb(record);

        OldBannerTurboLandingParams turboLandingParams = bannerTurboLandingParamsMapper.fromDb(record);
        if (turboLandingParams.getBannerId() != null) {
            banner.withTurboLandingParams(turboLandingParams);
        }
        return banner;
    }

    @Override
    public Stream<OldCpmAudioBanner> createBannersFromRecordsWithAdditionsAttached(int shard,
                                                                                   Collection<Record> records) {
        List<OldCpmAudioBanner> banners = records.stream().map(this::createBannerFromRecord).collect(toList());

        //достаем пиксели
        Set<Long> bannerIds = listToSet(banners, OldCpmAudioBanner::getId);
        Map<Long, List<String>> bannerIdToPixelUrls = bannerPixelsRepository.getPixelsByBannerIds(shard, bannerIds);
        var bannerIdToBannerMeasurers = bannerMeasurersRepository.getMeasurersByBannerIds(shard, bannerIds);
        return banners.stream().peek(banner -> banner
                .withPixels(defaultIfNull(bannerIdToPixelUrls.get(banner.getId()), emptyList()))
                .withMeasurers(defaultIfNull(bannerIdToBannerMeasurers.get(banner.getId()), emptyList()))
        );
    }
}
