package ru.yandex.direct.core.entity.banner.repository.old.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.impl.DSL;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.old.OldBannerCreative;
import ru.yandex.direct.core.entity.banner.model.old.OldBannerPixel;
import ru.yandex.direct.core.entity.banner.model.old.OldBannerTns;
import ru.yandex.direct.core.entity.banner.model.old.OldBannerType;
import ru.yandex.direct.core.entity.banner.model.old.OldBannerWithTns;
import ru.yandex.direct.core.entity.banner.model.old.OldCpmGeoPinBanner;
import ru.yandex.direct.core.entity.banner.repository.old.OldBannerMeasurersRepository;
import ru.yandex.direct.core.entity.banner.repository.old.OldBannerPixelsRepository;
import ru.yandex.direct.core.entity.banner.repository.old.container.BannerPixelsUpdateContainer;
import ru.yandex.direct.core.entity.banner.repository.old.container.InsertUpdateDeleteContainer;
import ru.yandex.direct.dbschema.ppc.tables.Banners;
import ru.yandex.direct.dbschema.ppc.tables.records.BannersRecord;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplier;
import ru.yandex.direct.jooqmapperhelper.InsertHelper;
import ru.yandex.direct.jooqmapperhelper.JooqUpdateBuilder;
import ru.yandex.direct.model.AppliedChanges;

import static java.util.Collections.emptyList;
import static java.util.stream.Collectors.toList;
import static org.apache.commons.lang3.ObjectUtils.defaultIfNull;
import static org.springframework.util.CollectionUtils.isEmpty;
import static ru.yandex.direct.core.entity.banner.repository.old.mapper.BannerCreativeMapperProvider.getBannerCreativeMapper;
import static ru.yandex.direct.core.entity.banner.repository.old.mapper.CpmGeoPinBannerMapperProvider.createCpmGeoPinBannerUpdateBuilder;
import static ru.yandex.direct.core.entity.banner.repository.old.mapper.CpmGeoPinBannerMapperProvider.getCpmGeoPinBannerMapper;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS;
import static ru.yandex.direct.utils.FunctionalUtils.listToSet;

/**
 * Реализация {@link OldBannerRepositoryTypeSupport} для медийных баннеров.
 */
@Component
@ParametersAreNonnullByDefault
@Deprecated
public class OldBannerRepositoryCpmGeoPinBannerTypeSupport extends OldAbstractBannerRepositoryTypeSupport<OldCpmGeoPinBanner> {

    private final OldBannerPixelsRepository bannerPixelsRepository;
    private final OldBannerWithOrganizationSupport bannerWithOrganizationSupport;
    private final OldBannerWithCreativeSupport bannerWithCreativeSupport;
    private final OldBannerWithPixelsSupport bannerWithPixelsSupport;
    private final OldBannerWithMeasurersSupport bannerWithMeasurersSupport;
    private final OldBannerMeasurersRepository bannerMeasurersRepository;

    private final JooqMapperWithSupplier<OldCpmGeoPinBanner> cpmGeoPinBannerMapper = getCpmGeoPinBannerMapper();
    private final JooqMapperWithSupplier<OldBannerCreative> bannerCreativeMapper = getBannerCreativeMapper();

    private final Collection<Field<?>> allFields;

    @Autowired
    OldBannerRepositoryCpmGeoPinBannerTypeSupport(
            DslContextProvider dslContextProvider,
            ShardHelper shardHelper,
            OldBannerPixelsRepository bannerPixelsRepository,
            OldBannerWithCreativeSupport bannerWithCreativeSupport,
            OldBannerWithPixelsSupport bannerWithPixelsSupport,
            OldBannerWithMeasurersSupport bannerWithMeasurersSupport,
            OldBannerMeasurersRepository bannerMeasurersRepository,
            OldBannerWithOrganizationSupport bannerWithOrganizationSupport) {
        super(dslContextProvider, shardHelper);

        this.bannerPixelsRepository = bannerPixelsRepository;
        this.bannerWithCreativeSupport = bannerWithCreativeSupport;
        this.bannerWithPixelsSupport = bannerWithPixelsSupport;
        this.bannerWithMeasurersSupport = bannerWithMeasurersSupport;
        this.bannerMeasurersRepository = bannerMeasurersRepository;
        this.bannerWithOrganizationSupport = bannerWithOrganizationSupport;

        allFields = Stream.of(cpmGeoPinBannerMapper.getFieldsToRead(),
                bannerCreativeMapper.getFieldsToRead())
                .flatMap(Collection::stream)
                .collect(toList());
    }

    @Override
    public OldBannerType getType() {
        return OldBannerType.CPM_GEO_PIN;
    }

    @Override
    public Collection<Field<?>> getAllFields() {
        return allFields;
    }

    @Override
    public void update(int shard, Collection<AppliedChanges<OldCpmGeoPinBanner>> appliedChanges) {
        InsertUpdateDeleteContainer<OldBannerCreative> bannerCreativesUpdateContainer =
                bannerWithCreativeSupport.prepareCreativesUpdateContainer(appliedChanges);
        Collection<OldBannerCreative> creativesToInsert = bannerCreativesUpdateContainer.getModelsToInsert();
        Collection<OldBannerCreative> creativesToUpdate = bannerCreativesUpdateContainer.getModelsToUpdate();
        Collection<OldBannerCreative> creativesToDelete = bannerCreativesUpdateContainer.getModelsToDelete();

        // подготовка пикселей к изменению
        BannerPixelsUpdateContainer bannerPixelsUpdateContainer =
                bannerWithPixelsSupport.preparePixelsUpdateContainer(appliedChanges);
        List<OldBannerPixel> bannersPixelsToAdd = bannerPixelsUpdateContainer.getBannerPixelsToAdd();
        Map<Long, List<String>> bannersPixelsToDelete = bannerPixelsUpdateContainer.getBannerPixelsToDelete();

        JooqUpdateBuilder<BannersRecord, OldCpmGeoPinBanner> bannerUpdateBuilder = createCpmGeoPinBannerUpdateBuilder(appliedChanges);

        dslContext(shard).transaction(ctx -> {
            DSL.using(ctx)
                    .update(BANNERS)
                    .set(bannerUpdateBuilder.getValues())
                    .where(Banners.BANNERS.BID.in(bannerUpdateBuilder.getChangedIds()))
                    .execute();

            bannerWithCreativeSupport.insertCreatives(ctx, creativesToInsert);
            bannerWithCreativeSupport.updateCreatives(ctx, creativesToUpdate);
            bannerWithCreativeSupport.deleteCreatives(ctx, creativesToDelete);

            bannerPixelsRepository.addBannerPixels(bannersPixelsToAdd, DSL.using(ctx));
            bannerPixelsRepository.deleteBannerPixels(bannersPixelsToDelete, DSL.using(ctx));

            updateBannerTnsTable(appliedChanges, DSL.using(ctx));

            bannerWithMeasurersSupport.updateMeasurers(appliedChanges, ctx);

            // Обработка привязок организаций к баннерам
            bannerWithOrganizationSupport.updateBannerPermalinks(DSL.using(ctx), appliedChanges);
        });
    }

    private void updateBannerTnsTable(Collection<AppliedChanges<OldCpmGeoPinBanner>> appliedChanges, DSLContext context) {
        List<OldBannerTns> newValues = new ArrayList<>();
        List<OldBannerTns> oldValues = new ArrayList<>();

        for (AppliedChanges<OldCpmGeoPinBanner> ac : appliedChanges) {
            if (!ac.changed(OldBannerWithTns.TNS_ID)) {
                continue;
            }
            OldBannerTns newValue = OldBannerPixelsRepository.extractBannerTns(ac.getModel());
            if (newValue.getTnsId() == null) {
                oldValues.add(newValue.withTnsId(ac.getOldValue(OldBannerWithTns.TNS_ID)));
            } else {
                newValues.add(newValue);
            }
        }

        bannerPixelsRepository.saveBannerTns(newValues, context);
        bannerPixelsRepository.deleteBannerTns(oldValues, context);
    }

    @Override
    public void add(int shard, Collection<OldCpmGeoPinBanner> banners) {
        // prepare
        bannerWithCreativeSupport.addBannerCreatives(banners, shard);
        bannerWithMeasurersSupport.addMeasurers(banners, shard);
        DSLContext dslContext = dslContext(shard);

        // write
        InsertHelper<BannersRecord> bannersInsertHelper = new InsertHelper<>(dslContext, BANNERS);
        bannersInsertHelper.addAll(cpmGeoPinBannerMapper, banners);

        bannersInsertHelper.executeIfRecordsAdded();

        addBannerToBannerPixelsTable(banners, dslContext);
        addBannerToBannersTnsTable(banners, dslContext);
        bannerWithOrganizationSupport.linkOrganizationsToBanners(dslContext, banners);
        bannerWithOrganizationSupport.addOrganizationCountersToBannersCampaigns(dslContext, banners);
    }

    private void addBannerToBannerPixelsTable(Collection<OldCpmGeoPinBanner> banners, DSLContext context) {
        List<OldBannerPixel> bannersAllPixelsList = banners
                .stream()
                .filter(b -> !isEmpty(b.getPixels()))
                .map(OldBannerPixelsRepository::extractBannerPixels)
                .flatMap(List::stream)
                .collect(toList());
        bannerPixelsRepository.addBannerPixels(bannersAllPixelsList, context);
    }

    private void addBannerToBannersTnsTable(Collection<OldCpmGeoPinBanner> banners, DSLContext context) {
        List<OldBannerTns> bannersAllTnsList = banners
                .stream()
                .map(OldBannerPixelsRepository::extractBannerTns)
                .filter(banner -> banner.getTnsId() != null)
                .collect(toList());
        bannerPixelsRepository.saveBannerTns(bannersAllTnsList, context);
    }

    @Override
    public OldCpmGeoPinBanner createBannerFromRecord(Record record) {
        var banner = cpmGeoPinBannerMapper.fromDb(record);

        return banner;
    }

    @Override
    public Stream<OldCpmGeoPinBanner> createBannersFromRecordsWithAdditionsAttached(int shard, Collection<Record> records) {
        var banners = records.stream().map(this::createBannerFromRecord).collect(toList());
        var bannerIds = listToSet(banners, OldCpmGeoPinBanner::getId);

        var bannerIdToPixelUrls = bannerPixelsRepository.getPixelsByBannerIds(shard, bannerIds);
        var bannerIdToBannerMeasurers = bannerMeasurersRepository.getMeasurersByBannerIds(shard, bannerIds);
        var bannerIdToBannerTns = bannerPixelsRepository.getTnsByIds(shard, bannerIds);

        return banners.stream().peek(banner ->
                banner.withPixels(defaultIfNull(bannerIdToPixelUrls.get(banner.getId()), emptyList()))
                        .withMeasurers(defaultIfNull(bannerIdToBannerMeasurers.get(banner.getId()), emptyList()))
                        .withTnsId(bannerIdToBannerTns.get(banner.getId()))
        );
    }
}
