package ru.yandex.direct.core.entity.banner.repository.old.type;

import java.util.Collection;
import java.util.stream.Stream;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.impl.DSL;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.old.OldBannerCreative;
import ru.yandex.direct.core.entity.banner.model.old.OldBannerType;
import ru.yandex.direct.core.entity.banner.model.old.OldCpmOutdoorBanner;
import ru.yandex.direct.core.entity.banner.repository.old.container.InsertUpdateDeleteContainer;
import ru.yandex.direct.dbschema.ppc.tables.Banners;
import ru.yandex.direct.dbschema.ppc.tables.records.BannersRecord;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplier;
import ru.yandex.direct.jooqmapperhelper.InsertHelper;
import ru.yandex.direct.jooqmapperhelper.JooqUpdateBuilder;
import ru.yandex.direct.model.AppliedChanges;

import static java.util.stream.Collectors.toList;
import static ru.yandex.direct.core.entity.banner.repository.old.mapper.BannerCreativeMapperProvider.getBannerCreativeMapper;
import static ru.yandex.direct.core.entity.banner.repository.old.mapper.CpmOutdoorBannerMapperProvider.createCpmOutdoorBannerUpdateBuilder;
import static ru.yandex.direct.core.entity.banner.repository.old.mapper.CpmOutdoorBannerMapperProvider.getCpmOutdoorBannerMapper;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS;

/**
 * Реализация {@link OldBannerRepositoryTypeSupport} для медийных outdoor баннеров.
 */
@Component
@ParametersAreNonnullByDefault
@Deprecated  // см. ru.yandex.direct.core.entity.banner.type.creative
public class OldBannerRepositoryCpmOutdoorTypeSupport extends OldAbstractBannerRepositoryTypeSupport<OldCpmOutdoorBanner> {

    private final OldBannerWithCreativeSupport bannerWithCreativeSupport;

    private final JooqMapperWithSupplier<OldCpmOutdoorBanner> cpmOutdoorBannerMapper =
            getCpmOutdoorBannerMapper();
    private final JooqMapperWithSupplier<OldBannerCreative> bannerCreativeMapper = getBannerCreativeMapper();

    private final Collection<Field<?>> allFields;

    @Autowired
    OldBannerRepositoryCpmOutdoorTypeSupport(
            DslContextProvider dslContextProvider,
            ShardHelper shardHelper,
            OldBannerWithCreativeSupport bannerWithCreativeSupport) {
        super(dslContextProvider, shardHelper);

        this.bannerWithCreativeSupport = bannerWithCreativeSupport;

        allFields = Stream.of(cpmOutdoorBannerMapper, bannerCreativeMapper)
                .map(JooqMapper::getFieldsToRead)
                .flatMap(Collection::stream)
                .collect(toList());
    }

    @Override
    public OldBannerType getType() {
        return OldBannerType.CPM_OUTDOOR;
    }

    @Override
    public Collection<Field<?>> getAllFields() {
        return allFields;
    }

    @Override
    public void update(int shard, Collection<AppliedChanges<OldCpmOutdoorBanner>> appliedChanges) {
        InsertUpdateDeleteContainer<OldBannerCreative> bannerCreativesUpdateContainer =
                bannerWithCreativeSupport.prepareCreativesUpdateContainer(appliedChanges);

        Collection<OldBannerCreative> creativesToUpdate = bannerCreativesUpdateContainer.getModelsToUpdate();

        JooqUpdateBuilder<BannersRecord, OldCpmOutdoorBanner> bannerUpdateBuilder =
                createCpmOutdoorBannerUpdateBuilder(appliedChanges);

        dslContext(shard).transaction(ctx -> {
            DSL.using(ctx)
                    .update(BANNERS)
                    .set(bannerUpdateBuilder.getValues())
                    .where(Banners.BANNERS.BID.in(bannerUpdateBuilder.getChangedIds()))
                    .execute();

            bannerWithCreativeSupport.updateCreatives(ctx, creativesToUpdate);
        });
    }

    @Override
    public void add(int shard, Collection<OldCpmOutdoorBanner> banners) {
        // prepare
        bannerWithCreativeSupport.addBannerCreatives(banners, shard);
        DSLContext dslContext = dslContext(shard);

        // write
        InsertHelper.saveModelObjectsToDbTable(dslContext, BANNERS, cpmOutdoorBannerMapper, banners);
    }

    @Override
    public OldCpmOutdoorBanner createBannerFromRecord(Record record) {
        return cpmOutdoorBannerMapper.fromDb(record);
    }

    @Override
    public Stream<OldCpmOutdoorBanner> createBannersFromRecordsWithAdditionsAttached(int shard,
                                                                                     Collection<Record> records) {
        return records.stream().map(this::createBannerFromRecord);
    }
}
