package ru.yandex.direct.core.entity.banner.repository.old.type;

import java.util.Collection;
import java.util.Map;
import java.util.stream.Stream;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.ImmutableList;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.old.InternalAdExtraInfo;
import ru.yandex.direct.core.entity.banner.model.old.InternalAdExtraInfoOnly;
import ru.yandex.direct.core.entity.banner.model.old.OldBannerType;
import ru.yandex.direct.core.entity.banner.model.old.OldInternalBanner;
import ru.yandex.direct.core.entity.banner.repository.old.mapper.BannerInternalMapperProvider;
import ru.yandex.direct.core.entity.domain.service.DomainService;
import ru.yandex.direct.dbschema.ppc.tables.records.BannersInternalRecord;
import ru.yandex.direct.dbschema.ppc.tables.records.BannersRecord;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplier;
import ru.yandex.direct.jooqmapperhelper.InsertHelper;
import ru.yandex.direct.jooqmapperhelper.JooqUpdateBuilder;
import ru.yandex.direct.model.AppliedChanges;

import static com.google.common.base.Preconditions.checkState;
import static java.util.Collections.emptyMap;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS_INTERNAL;

@Component
@ParametersAreNonnullByDefault
@Deprecated
public class OldBannerRepositoryInternalTypeSupport extends OldAbstractBannerRepositoryTypeSupport<OldInternalBanner> {

    private final DomainService domainService;

    private final JooqMapperWithSupplier<OldInternalBanner> bannerInternalMapper;
    private final Collection<Field<?>> allFields;
    private final JooqMapperWithSupplier<InternalAdExtraInfoOnly> internalExtraInfoMapper;
    private final BannerInternalMapperProvider bannerInternalMapperProvider;

    public OldBannerRepositoryInternalTypeSupport(DslContextProvider dslContextProvider,
                                                  ShardHelper shardHelper,
                                                  DomainService domainService,
                                                  BannerInternalMapperProvider bannerInternalMapperProvider) {
        super(dslContextProvider, shardHelper);
        this.domainService = domainService;

        this.bannerInternalMapper = bannerInternalMapperProvider.getBannerInternalMapper();
        this.internalExtraInfoMapper = bannerInternalMapperProvider.getInternalExtraInfoMapper();
        this.bannerInternalMapperProvider = bannerInternalMapperProvider;
        //noinspection UnstableApiUsage
        this.allFields = Stream.of(bannerInternalMapper)
                .map(JooqMapper::getFieldsToRead)
                .flatMap(Collection::stream)
                .collect(ImmutableList.toImmutableList());
    }

    @Override
    public OldBannerType getType() {
        return OldBannerType.INTERNAL;
    }

    @Override
    public Collection<Field<?>> getAllFields() {
        return allFields;
    }

    @Override
    public void add(int shard, Collection<OldInternalBanner> banners) {
        domainService.addDomainsAndSetDomainIds(shard, banners);

        dslContext(shard).transaction(ctx -> {
            DSLContext dslContext = ctx.dsl();
            new InsertHelper<>(dslContext, BANNERS)
                    .addAll(bannerInternalMapper, banners)
                    .executeIfRecordsAdded();
            new InsertHelper<>(dslContext, BANNERS_INTERNAL)
                    .addAll(bannerInternalMapper, banners)
                    .executeIfRecordsAdded();
        });
    }

    @Override
    public void update(int shard, Collection<AppliedChanges<OldInternalBanner>> appliedChanges) {
        checkState(appliedChanges.stream().noneMatch(b -> b.changed(OldInternalBanner.TEMPLATE_ID)),
                "templateId must not be changed for InternalBanner");

        domainService.addNewDomainsAndUpdateDomainIds(shard, appliedChanges);

        JooqUpdateBuilder<BannersRecord, OldInternalBanner> bannerUpdateBuilder =
                bannerInternalMapperProvider.createInternalBannerUpdateBuilder(appliedChanges);
        JooqUpdateBuilder<BannersInternalRecord, OldInternalBanner> bannersInternalUpdateBuilder =
                bannerInternalMapperProvider.createBannersInternalUpdateBuilder(appliedChanges);

        dslContext(shard).transaction(ctx -> {
            DSL.using(ctx)
                    .update(BANNERS)
                    .set(bannerUpdateBuilder.getValues())
                    .where(BANNERS.BID.in(bannerUpdateBuilder.getChangedIds()))
                    .execute();

            DSL.using(ctx)
                    .update(BANNERS_INTERNAL)
                    .set(bannersInternalUpdateBuilder.getValues())
                    .where(BANNERS_INTERNAL.BID.in(bannersInternalUpdateBuilder.getChangedIds()))
                    .execute();
        });
    }

    @Override
    public OldInternalBanner createBannerFromRecord(Record record) {
        return bannerInternalMapper.fromDb(record);
    }

    @Override
    public Stream<OldInternalBanner> createBannersFromRecordsWithAdditionsAttached(int shard, Collection<Record> records) {
        return records.stream().map(this::createBannerFromRecord);
    }

    /**
     * Получить только специфичную для баннеров внутренней рекламы информацию, без остальных полей баннера.
     * Метод создан для гридов, т.к. там основная информация о баннерах приходит из Yt, и из MySQL запрашивается
     * лишь дополнение к общим полям баннеров.
     *
     * @param bannerIds идентификаторы баннеров, для которых будет выдана доп. информация
     * @return отображение идентификатора баннера к доп. информации, с ним ассоциированной
     */
    public Map<Long, InternalAdExtraInfo> getInternalAdExtraInfoByBannerId(int shard, Collection<Long> bannerIds) {
        if (bannerIds.isEmpty()) {
            return emptyMap();
        }
        return dslContext(shard)
                .select(BANNERS_INTERNAL.BID)
                .select(internalExtraInfoMapper.getFieldsToRead())
                .from(BANNERS_INTERNAL)
                .where(BANNERS_INTERNAL.BID.in(bannerIds))
                .fetchMap(BANNERS_INTERNAL.BID, internalExtraInfoMapper::fromDb);
    }

}
