package ru.yandex.direct.core.entity.banner.repository.old.type;

import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.impl.DSL;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.old.OldBannerImage;
import ru.yandex.direct.core.entity.banner.model.old.OldBannerType;
import ru.yandex.direct.core.entity.banner.model.old.OldMobileAppBanner;
import ru.yandex.direct.core.entity.banner.repository.old.OldBannerImageRepository;
import ru.yandex.direct.core.entity.banner.repository.old.container.AddOrUpdateAndDeleteContainer;
import ru.yandex.direct.core.entity.domain.service.DomainService;
import ru.yandex.direct.core.entity.domain.service.OldBannerAggregatorDomainsService;
import ru.yandex.direct.dbschema.ppc.tables.records.BannersMobileContentRecord;
import ru.yandex.direct.dbschema.ppc.tables.records.BannersRecord;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplier;
import ru.yandex.direct.jooqmapperhelper.InsertHelper;
import ru.yandex.direct.jooqmapperhelper.JooqUpdateBuilder;
import ru.yandex.direct.model.AppliedChanges;

import static java.util.stream.Collectors.toList;
import static ru.yandex.direct.core.entity.banner.repository.old.mapper.BannerImageMapperProvider.getBannerImageMapper;
import static ru.yandex.direct.core.entity.banner.repository.old.mapper.MobileAppBannerMapperProvider.MAPPER;
import static ru.yandex.direct.core.entity.banner.repository.old.mapper.MobileAppBannerMapperProvider.createBannersMobileContentUpdateBuilder;
import static ru.yandex.direct.core.entity.banner.repository.old.mapper.MobileAppBannerMapperProvider.createBannersUpdateBuilder;
import static ru.yandex.direct.core.entity.banner.repository.old.type.OldBannerWithBannerImageSupport.prepareBannerImagesUpdateContainer;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS_MOBILE_CONTENT;
import static ru.yandex.direct.dbschema.ppc.tables.Banners.BANNERS;

@Component
@ParametersAreNonnullByDefault
@Deprecated
class OldBannerRepositoryMobileAppTypeSupport extends OldAbstractBannerRepositoryTypeSupport<OldMobileAppBanner> {

    private final DomainService domainService;
    private final OldBannerImageRepository imageRepository;
    private final OldBannerAggregatorDomainsService aggregatorDomainsService;
    private final Collection<Field<?>> allFields;

    private final JooqMapperWithSupplier<OldMobileAppBanner> mobileAppBannerMapper;
    private final JooqMapperWithSupplier<OldBannerImage> bannerImageMapper;

    @Autowired
    OldBannerRepositoryMobileAppTypeSupport(DslContextProvider contextProvider,
                                            ShardHelper shardHelper,
                                            DomainService domainService,
                                            OldBannerImageRepository imageRepository,
                                            OldBannerAggregatorDomainsService aggregatorDomainsService) {
        super(contextProvider, shardHelper);

        this.domainService = domainService;
        this.imageRepository = imageRepository;
        this.aggregatorDomainsService = aggregatorDomainsService;

        mobileAppBannerMapper = MAPPER;
        bannerImageMapper = getBannerImageMapper();

        allFields = Stream.of(mobileAppBannerMapper, bannerImageMapper)
                .map(JooqMapper::getFieldsToRead)
                .flatMap(Collection::stream)
                .collect(toList());
    }

    @Override
    public OldBannerType getType() {
        return OldBannerType.MOBILE_CONTENT;
    }

    @Override
    public Collection<Field<?>> getAllFields() {
        return allFields;
    }

    /**
     * @param shard   шард
     * @param banners баннеры
     * @inheritDoc Проставляются {@link OldBannerImage#ID}, создаются домены и креативы.
     */
    @Override
    public void beforeBannersAdd(int shard, Collection<OldMobileAppBanner> banners) {
        domainService.addDomainsAndSetDomainIds(shard, banners);
    }

    @Override
    public void addBannersToDb(Collection<OldMobileAppBanner> banners, DSLContext context) {
        new InsertHelper<>(context, BANNERS)
                .addAll(mobileAppBannerMapper, banners)
                .executeIfRecordsAdded();
    }

    @Override
    public void afterBannersAdded(Collection<OldMobileAppBanner> banners, DSLContext context) {
        imageRepository.addOrUpdateBannerImage(banners, context);

        aggregatorDomainsService.updateAggregatorDomains(context, banners);

        new InsertHelper<>(context, BANNERS_MOBILE_CONTENT)
                .addAll(mobileAppBannerMapper, banners)
                .executeIfRecordsAdded();
    }

    @Override
    public OldMobileAppBanner createBannerFromRecord(Record record) {
        OldMobileAppBanner banner = mobileAppBannerMapper.fromDb(record);

        if (bannerImageMapper.canReadAtLeastOneProperty(record.fields())) {
            OldBannerImage bannerImage = bannerImageMapper.fromDb(record);
            if (bannerImage.getId() != null) {
                banner.withBannerImage(bannerImage);
            }
        }

        return banner;
    }

    @Override
    public Stream<OldMobileAppBanner> createBannersFromRecordsWithAdditionsAttached(int shard,
                                                                                    Collection<Record> records) {
        return records.stream().map(this::createBannerFromRecord);
    }

    @Override
    public void update(int shard, Collection<AppliedChanges<OldMobileAppBanner>> appliedChanges) {
        domainService.addNewDomainsAndUpdateDomainIds(shard, appliedChanges);

        // prepare banner image to update
        AddOrUpdateAndDeleteContainer<OldMobileAppBanner> bannerImagesUpdateContainer =
                prepareBannerImagesUpdateContainer(appliedChanges);
        List<OldMobileAppBanner> bannersToAddOrUpdateImages = bannerImagesUpdateContainer.getModelsToAddOrUpdate();
        List<OldMobileAppBanner> bannersToDeleteImages = bannerImagesUpdateContainer.getModelsToDelete();

        JooqUpdateBuilder<BannersRecord, OldMobileAppBanner> bannerBuilder = createBannersUpdateBuilder(appliedChanges);
        JooqUpdateBuilder<BannersMobileContentRecord, OldMobileAppBanner> mobileContentBuilder
                = createBannersMobileContentUpdateBuilder(appliedChanges);
        final DSLContext context = dslContext(shard);
        context.transaction(ctx -> {
            DSL.using(ctx)
                    .update(BANNERS)
                    .set(bannerBuilder.getValues())
                    .where(BANNERS.BID.in(bannerBuilder.getChangedIds()))
                    .execute();

            DSL.using(ctx)
                    .update(BANNERS_MOBILE_CONTENT)
                    .set(mobileContentBuilder.getValues())
                    .where(BANNERS_MOBILE_CONTENT.BID.in(mobileContentBuilder.getChangedIds()))
                    .execute();


            // add or update banner images
            imageRepository.addOrUpdateBannerImage(bannersToAddOrUpdateImages, DSL.using(ctx));

            // "delete" banner images - change status show to 'No'
            if (!bannersToDeleteImages.isEmpty()) {
                imageRepository.deleteBannerImages(shard, bannersToDeleteImages);
            }

            aggregatorDomainsService.updateAggregatorDomains(ctx, appliedChanges);
        });
    }
}
