package ru.yandex.direct.core.entity.banner.repository.old.type;

import java.util.Collection;
import java.util.stream.Stream;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.impl.DSL;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.old.OldBannerCreative;
import ru.yandex.direct.core.entity.banner.model.old.OldBannerType;
import ru.yandex.direct.core.entity.banner.model.old.OldPerformanceBanner;
import ru.yandex.direct.core.entity.banner.repository.old.container.InsertUpdateDeleteContainer;
import ru.yandex.direct.core.entity.banner.repository.old.mapper.PerformanceBannerMapperProvider;
import ru.yandex.direct.dbschema.ppc.tables.records.BannersRecord;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplier;
import ru.yandex.direct.jooqmapperhelper.InsertHelper;
import ru.yandex.direct.jooqmapperhelper.JooqUpdateBuilder;
import ru.yandex.direct.model.AppliedChanges;

import static java.util.stream.Collectors.toList;
import static ru.yandex.direct.dbschema.ppc.tables.Banners.BANNERS;

/**
 * Реализация {@link OldBannerRepositoryTypeSupport} для performance баннеров
 */
@Component
@ParametersAreNonnullByDefault
@Deprecated
class OldBannerRepositoryPerformanceTypeSupport extends OldAbstractBannerRepositoryTypeSupport<OldPerformanceBanner> {

    private final OldBannerWithCreativeSupport bannerWithCreativeSupport;
    private final PerformanceBannerMapperProvider performanceBannerMapperProvider;
    private final JooqMapperWithSupplier<OldPerformanceBanner> performanceBannerMapper;
    private final Collection<Field<?>> allFields;

    @Autowired
    OldBannerRepositoryPerformanceTypeSupport(DslContextProvider dslContextProvider,
                                              ShardHelper shardHelper,
                                              OldBannerWithCreativeSupport bannerWithCreativeSupport,
                                              PerformanceBannerMapperProvider performanceBannerMapperProvider) {
        super(dslContextProvider, shardHelper);

        this.bannerWithCreativeSupport = bannerWithCreativeSupport;
        this.performanceBannerMapperProvider = performanceBannerMapperProvider;
        this.performanceBannerMapper = performanceBannerMapperProvider.getPerformanceBannerMapper();

        this.allFields = Stream.of(performanceBannerMapper)
                .map(JooqMapper::getFieldsToRead)
                .flatMap(Collection::stream)
                .collect(toList());
    }

    @Override
    public OldBannerType getType() {
        return OldBannerType.PERFORMANCE;
    }

    @Override
    public Collection<Field<?>> getAllFields() {
        return allFields;
    }

    @Override
    public void update(int shard, Collection<AppliedChanges<OldPerformanceBanner>> appliedChanges) {
        JooqUpdateBuilder<BannersRecord, OldPerformanceBanner> bannerUpdateBuilder =
                performanceBannerMapperProvider.createPerformanceBannerUpdateBuilder(appliedChanges);

        InsertUpdateDeleteContainer<OldBannerCreative> creativesUpdateContainer =
                bannerWithCreativeSupport.prepareCreativesUpdateContainer(appliedChanges);
        Collection<OldBannerCreative> bannerCreativeToInsert = creativesUpdateContainer.getModelsToInsert();
        Collection<OldBannerCreative> bannerCreativeToUpdate = creativesUpdateContainer.getModelsToUpdate();
        Collection<OldBannerCreative> bannerCreativeToDelete = creativesUpdateContainer.getModelsToDelete();

        final DSLContext context = dslContext(shard);
        context.transaction(ctx -> {
            DSL.using(ctx)
                    .update(BANNERS)
                    .set(bannerUpdateBuilder.getValues())
                    .where(BANNERS.BID.in(bannerUpdateBuilder.getChangedIds()))
                    .execute();

            // banner creative
            bannerWithCreativeSupport.insertCreatives(ctx, bannerCreativeToInsert);
            bannerWithCreativeSupport.updateCreatives(ctx, bannerCreativeToUpdate);
            bannerWithCreativeSupport.deleteCreatives(ctx, bannerCreativeToDelete);
        });
    }

    @Override
    public void beforeBannersAdd(int shard, Collection<OldPerformanceBanner> banners) {
        bannerWithCreativeSupport.addBannerCreatives(banners, shard);
    }

    @Override
    public void addBannersToDb(Collection<OldPerformanceBanner> banners, DSLContext dslContext) {
        new InsertHelper<>(dslContext, BANNERS)
                .addAll(performanceBannerMapper, banners)
                .executeIfRecordsAdded();
    }

    @Override
    public void afterBannersAdded(Collection<OldPerformanceBanner> banners, DSLContext dslContext) {
    }

    @Override
    public OldPerformanceBanner createBannerFromRecord(Record record) {
        return performanceBannerMapper.fromDb(record);
    }

    @Override
    public Stream<OldPerformanceBanner> createBannersFromRecordsWithAdditionsAttached(int shard,
                                                                                      Collection<Record> records) {
        return records.stream().map(this::createBannerFromRecord);
    }
}
