package ru.yandex.direct.core.entity.banner.repository.old.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.impl.DSL;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.BannerAddition;
import ru.yandex.direct.core.entity.banner.model.old.OldBannerButton;
import ru.yandex.direct.core.entity.banner.model.old.OldBannerCreative;
import ru.yandex.direct.core.entity.banner.model.old.OldBannerImage;
import ru.yandex.direct.core.entity.banner.model.old.OldBannerPrice;
import ru.yandex.direct.core.entity.banner.model.old.OldBannerType;
import ru.yandex.direct.core.entity.banner.model.old.OldBannerWithButton;
import ru.yandex.direct.core.entity.banner.model.old.OldTextBanner;
import ru.yandex.direct.core.entity.banner.repository.old.OldBannerAdditionsRepository;
import ru.yandex.direct.core.entity.banner.repository.old.OldBannerButtonsRepository;
import ru.yandex.direct.core.entity.banner.repository.old.OldBannerHrefRepository;
import ru.yandex.direct.core.entity.banner.repository.old.OldBannerImageRepository;
import ru.yandex.direct.core.entity.banner.repository.old.OldBannerLogosRepository;
import ru.yandex.direct.core.entity.banner.repository.old.OldBannerPricesRepository;
import ru.yandex.direct.core.entity.banner.repository.old.OldBannerTurboAppsRepository;
import ru.yandex.direct.core.entity.banner.repository.old.OldBannerTurboGalleriesRepository;
import ru.yandex.direct.core.entity.banner.repository.old.container.AddOrUpdateAndDeleteContainer;
import ru.yandex.direct.core.entity.banner.repository.old.container.CalloutsUpdateContainer;
import ru.yandex.direct.core.entity.banner.repository.old.container.InsertUpdateDeleteContainer;
import ru.yandex.direct.core.entity.banner.turbolanding.model.OldBannerTurboLanding;
import ru.yandex.direct.core.entity.banner.turbolanding.model.OldBannerTurboLandingParams;
import ru.yandex.direct.core.entity.domain.service.DomainService;
import ru.yandex.direct.core.entity.domain.service.OldBannerAggregatorDomainsService;
import ru.yandex.direct.dbschema.ppc.tables.records.BannersRecord;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplier;
import ru.yandex.direct.jooqmapperhelper.InsertHelper;
import ru.yandex.direct.jooqmapperhelper.JooqUpdateBuilder;
import ru.yandex.direct.model.AppliedChanges;

import static java.util.Collections.emptyList;
import static java.util.function.Function.identity;
import static java.util.stream.Collectors.toList;
import static org.apache.commons.lang3.ObjectUtils.defaultIfNull;
import static org.springframework.util.CollectionUtils.isEmpty;
import static ru.yandex.direct.core.entity.banner.repository.old.mapper.BannerImageMapperProvider.getBannerImageMapper;
import static ru.yandex.direct.core.entity.banner.repository.old.mapper.BannerPriceMapperProvider.getBannerPriceMapper;
import static ru.yandex.direct.core.entity.banner.repository.old.mapper.TextBannerMapperProvider.createTextBannerUpdateBuilder;
import static ru.yandex.direct.core.entity.banner.repository.old.mapper.TextBannerMapperProvider.getTextBannerMapper;
import static ru.yandex.direct.core.entity.banner.repository.old.mapper.turbolanding.BannerTurboLandingMapperProvider.getBannerTurboLandingMapper;
import static ru.yandex.direct.core.entity.banner.repository.old.mapper.turbolanding.BannerTurboLandingParamsMapperProvider.getBannerTurboLandingParamsMapper;
import static ru.yandex.direct.core.entity.banner.repository.old.type.OldBannerWithBannerImageSupport.prepareBannerImagesUpdateContainer;
import static ru.yandex.direct.dbschema.ppc.tables.BannerDisplayHrefs.BANNER_DISPLAY_HREFS;
import static ru.yandex.direct.dbschema.ppc.tables.Banners.BANNERS;
import static ru.yandex.direct.utils.FunctionalUtils.filterAndMapList;
import static ru.yandex.direct.utils.FunctionalUtils.filterList;
import static ru.yandex.direct.utils.FunctionalUtils.listToSet;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

/**
 * Реализация {@link OldBannerRepositoryTypeSupport} для текстовых баннеров.
 */
@Component
@ParametersAreNonnullByDefault
@Deprecated
        // см ru.yandex.direct.core.entity.banner.model.NewTextBanner
class OldBannerRepositoryTextTypeSupport extends OldAbstractBannerRepositoryTypeSupport<OldTextBanner> {

    private final OldBannerAdditionsRepository bannerAdditionsRepository;
    private final OldBannerImageRepository bannerImageRepository;
    private final DomainService domainService;
    private final OldBannerHrefRepository bannerHrefRepository;
    private final OldBannerWithCreativeSupport bannerWithCreativeSupport;
    private final OldBannerWithCalloutsSupport bannerWithCalloutsSupport;
    private final OldBannerWithTurboLandingSupport bannerWithTurboLandingSupport;
    private final OldBannerPricesRepository bannerPricesRepository;
    private final OldBannerWithOrganizationSupport bannerWithOrganizationSupport;
    private final OldBannerTurboGalleriesRepository bannerTurboGalleriesRepository;
    private final OldBannerAggregatorDomainsService aggregatorDomainsService;
    private final OldBannerTurboAppsRepository bannerTurboAppsRepository;
    private final OldBannerLogosRepository<OldTextBanner> bannerLogosRepository;
    private final OldBannerButtonsRepository bannerButtonsRepository;

    private final JooqMapperWithSupplier<OldTextBanner> textBannerMapper = getTextBannerMapper();
    private final JooqMapperWithSupplier<OldBannerImage> bannerImageMapper = getBannerImageMapper();
    private final JooqMapperWithSupplier<OldBannerTurboLanding> bannerTurboLandingMapper =
            getBannerTurboLandingMapper();
    private final JooqMapperWithSupplier<OldBannerTurboLandingParams> bannerTurboLandingParamsMapper =
            getBannerTurboLandingParamsMapper();
    private final JooqMapperWithSupplier<OldBannerPrice> bannerPriceMapper = getBannerPriceMapper();

    private final Collection<Field<?>> allFields;

    @Autowired
    OldBannerRepositoryTextTypeSupport(DslContextProvider dslContextProvider,
                                       ShardHelper shardHelper,
                                       OldBannerAdditionsRepository bannerAdditionsRepository,
                                       OldBannerImageRepository bannerImageRepository,
                                       DomainService domainService,
                                       OldBannerHrefRepository bannerHrefRepository,
                                       OldBannerWithCreativeSupport bannerWithCreativeSupport,
                                       OldBannerWithCalloutsSupport bannerWithCalloutsSupport,
                                       OldBannerWithTurboLandingSupport bannerWithTurboLandingSupport,
                                       OldBannerPricesRepository bannerPricesRepository,
                                       OldBannerWithOrganizationSupport bannerWithOrganizationSupport,
                                       OldBannerTurboGalleriesRepository bannerTurboGalleriesRepository,
                                       OldBannerAggregatorDomainsService aggregatorDomainsService,
                                       OldBannerTurboAppsRepository bannerTurboAppsRepository,
                                       OldBannerButtonsRepository bannerButtonsRepository) {
        super(dslContextProvider, shardHelper);

        this.bannerAdditionsRepository = bannerAdditionsRepository;
        this.bannerImageRepository = bannerImageRepository;
        this.domainService = domainService;
        this.bannerHrefRepository = bannerHrefRepository;
        this.bannerWithCreativeSupport = bannerWithCreativeSupport;
        this.bannerWithCalloutsSupport = bannerWithCalloutsSupport;
        this.bannerWithTurboLandingSupport = bannerWithTurboLandingSupport;
        this.bannerPricesRepository = bannerPricesRepository;
        this.bannerWithOrganizationSupport = bannerWithOrganizationSupport;
        this.bannerTurboGalleriesRepository = bannerTurboGalleriesRepository;
        this.aggregatorDomainsService = aggregatorDomainsService;
        this.bannerTurboAppsRepository = bannerTurboAppsRepository;
        this.bannerLogosRepository = new OldBannerLogosRepository<>(dslContextProvider, OldTextBanner::new);
        this.bannerButtonsRepository = bannerButtonsRepository;

        allFields = Stream.of(
                textBannerMapper.getFieldsToRead(),
                bannerTurboLandingMapper.getFieldsToRead(),
                bannerTurboLandingParamsMapper.getFieldsToRead(),
                bannerImageMapper.getFieldsToRead(),
                bannerPriceMapper.getFieldsToRead()
        ).flatMap(Collection::stream)
                .collect(toList());
    }

    @Override
    public OldBannerType getType() {
        return OldBannerType.TEXT;
    }

    @Override
    public Collection<Field<?>> getAllFields() {
        return allFields;
    }

    /**
     * @param shard          шард
     * @param appliedChanges изменения моделей
     * @inheritDoc Обновление некоторых полей баннера и таблицы bannerPerformance (если креатив изменялся).
     */
    @Override
    public void update(int shard, Collection<AppliedChanges<OldTextBanner>> appliedChanges) {

        domainService.addNewDomainsAndUpdateDomainIds(shard, appliedChanges);

        //подготовка уточнений к изменению
        CalloutsUpdateContainer calloutsUpdateContainer =
                bannerWithCalloutsSupport.prepareCalloutsUpdateContainer(appliedChanges);
        List<BannerAddition> bannersCalloutsToAddOrUpdate = calloutsUpdateContainer.getBannersCalloutsToAddOrUpdate();
        Map<Long, List<Long>> bannersCalloutsToDelete = calloutsUpdateContainer.getBannersCalloutsToDelete();

        // prepare banner image to update
        AddOrUpdateAndDeleteContainer<OldTextBanner> bannerImagesUpdateContainer =
                prepareBannerImagesUpdateContainer(appliedChanges);
        List<OldTextBanner> bannersToAddOrUpdateImages = bannerImagesUpdateContainer.getModelsToAddOrUpdate();
        List<OldTextBanner> bannersToDeleteImages = bannerImagesUpdateContainer.getModelsToDelete();

        // prepare banner displayHref to update
        AddOrUpdateAndDeleteContainer<OldTextBanner> displayHrefsUpdateContainer =
                bannerHrefRepository.prepareDisplayHrefsUpdateContainer(appliedChanges);
        Set<Long> displayHrefBidsToDelete =
                listToSet(displayHrefsUpdateContainer.getModelsToDelete(), OldTextBanner::getId);
        List<OldTextBanner> bannersToAddOrUpdateDisplayHrefs = displayHrefsUpdateContainer.getModelsToAddOrUpdate();

        // prepare banner prices to update
        AddOrUpdateAndDeleteContainer<OldTextBanner> bannerPricesContainer =
                prepareBannerPricesUpdateContainer(appliedChanges);
        List<OldTextBanner> bannersToUpdateTurboAppStatus = getChangedPriceBanners(appliedChanges);
        List<AppliedChanges<OldTextBanner>> bannersChangesToUpdateTurboAppStatus =
                getChangesForPriceBanners(appliedChanges);

        // prepare turbo-gallery href to update
        AddOrUpdateAndDeleteContainer<OldTextBanner> turboGalleryHrefContainer =
                prepareBannerTurboGalleryUpdateContainer(appliedChanges);
        List<Long> bannerIdsToDeleteTurboGalleryHref =
                mapList(turboGalleryHrefContainer.getModelsToDelete(), OldTextBanner::getId);

        JooqUpdateBuilder<BannersRecord, OldTextBanner> bannerUpdateBuilder =
                createTextBannerUpdateBuilder(appliedChanges);

        InsertUpdateDeleteContainer<OldBannerCreative> creativesUpdateContainer =
                bannerWithCreativeSupport.prepareCreativesUpdateContainer(appliedChanges);
        Collection<OldBannerCreative> bannerCreativeToInsert = creativesUpdateContainer.getModelsToInsert();
        Collection<OldBannerCreative> bannerCreativeToUpdate = creativesUpdateContainer.getModelsToUpdate();
        Collection<OldBannerCreative> bannerCreativeToDelete = creativesUpdateContainer.getModelsToDelete();

        final DSLContext context = dslContext(shard);
        context.transaction(ctx -> {
            DSLContext dslContext = DSL.using(ctx);
            dslContext
                    .update(BANNERS)
                    .set(bannerUpdateBuilder.getValues())
                    .where(BANNERS.BID.in(bannerUpdateBuilder.getChangedIds()))
                    .execute();

            // add or update banner displayHrefs
            bannerHrefRepository.addOrUpdateBannerDisplayHrefs(dslContext, bannersToAddOrUpdateDisplayHrefs);

            // delete display hrefs
            if (!displayHrefBidsToDelete.isEmpty()) {
                bannerHrefRepository.deleteBannerDisplayHrefs(dslContext, displayHrefBidsToDelete);
            }
            // add or update banner images
            bannerImageRepository.addOrUpdateBannerImage(bannersToAddOrUpdateImages, dslContext);

            // "delete" banner images - change status show to 'No'
            if (!bannersToDeleteImages.isEmpty()) {
                bannerImageRepository.deleteBannerImages(shard, bannersToDeleteImages);
            }

            // привязка уточнений баннеру
            bannerAdditionsRepository.addOrUpdateBannerAdditions(dslContext, bannersCalloutsToAddOrUpdate);

            // отвязка уточнений от баннера
            bannerAdditionsRepository.deleteBannersAdditions(bannersCalloutsToDelete, dslContext);

            // обновление турболендингов
            bannerWithTurboLandingSupport.updateTurbolandings(appliedChanges, ctx);

            // обновление параметров турболендингов
            bannerWithTurboLandingSupport.updateTurbolandingParams(appliedChanges, ctx);

            // Добавление-обновление цен
            bannerPricesRepository.addOrUpdateBannerPrices(bannerPricesContainer.getModelsToAddOrUpdate(), dslContext);
            // Удаление цен
            bannerPricesRepository.deleteBannerPrices(bannerPricesContainer.getModelsToDelete(), dslContext);

            // Обновление статуса баннера с турбо-аппами
            bannerTurboAppsRepository.updateBannerTurboAppTypes(bannersChangesToUpdateTurboAppStatus, dslContext);

            // Удаление ссылок на турбо-галерею
            bannerTurboGalleriesRepository.deleteBannerTurboGalleryHref(bannerIdsToDeleteTurboGalleryHref, dslContext);
            // Обновление ссылок на турбо-галерею
            bannerTurboGalleriesRepository
                    .addOrUpdateBannerTurboGallery(turboGalleryHrefContainer.getModelsToAddOrUpdate(), dslContext);

            // Обработка привязок организаций к баннерам
            bannerWithOrganizationSupport.updateBannerPermalinks(dslContext, appliedChanges);

            // banner creative
            bannerWithCreativeSupport.insertCreatives(ctx, bannerCreativeToInsert);
            bannerWithCreativeSupport.updateCreatives(ctx, bannerCreativeToUpdate);
            bannerWithCreativeSupport.deleteCreatives(ctx, bannerCreativeToDelete);

            aggregatorDomainsService.updateAggregatorDomains(ctx, appliedChanges);
        });
    }

    /**
     * @param shard   шард
     * @param banners баннеры
     * @inheritDoc Проставляются {@link OldBannerImage#ID}, создаются домены и креативы.
     */
    @Override
    public void beforeBannersAdd(int shard, Collection<OldTextBanner> banners) {
        domainService.addDomainsAndSetDomainIds(shard, banners);
        bannerWithCreativeSupport.addBannerCreatives(banners, shard);
    }

    @Override
    public void addBannersToDb(Collection<OldTextBanner> banners, DSLContext dslContext) {
        new InsertHelper<>(dslContext, BANNERS)
                .addAll(textBannerMapper, banners)
                .executeIfRecordsAdded();
    }

    @Override
    public void afterBannersAdded(Collection<OldTextBanner> banners, DSLContext dslContext) {
        bannerImageRepository.addOrUpdateBannerImage(banners, dslContext);
        addBannerToBannerDisplayHrefsTable(banners, dslContext);
        addBannerToBannerAdditionTable(banners, dslContext);
        addBannerToBannerLogosTable(banners, dslContext);
        addBannerToBannerButtonsTable(banners, dslContext);
        bannerPricesRepository.addOrUpdateBannerPrices(banners, dslContext);
        bannerWithOrganizationSupport.linkOrganizationsToBanners(dslContext, banners);
        bannerWithOrganizationSupport.linkPhoneIdsToBanners(dslContext, banners);
        bannerWithTurboLandingSupport.updateAfterBannersAdded(banners, dslContext);
        bannerTurboGalleriesRepository.addOrUpdateBannerTurboGallery(banners, dslContext);
        aggregatorDomainsService.updateAggregatorDomains(dslContext, banners);

        bannerWithOrganizationSupport.addOrganizationCountersToBannersCampaigns(dslContext, banners);
    }

    private void addBannerToBannerDisplayHrefsTable(Collection<OldTextBanner> banners, DSLContext context) {
        Predicate<OldTextBanner> ifDisplayHrefNotNull = banner -> banner.getDisplayHref() != null;

        new InsertHelper<>(context, BANNER_DISPLAY_HREFS)
                .addAll(textBannerMapper, banners, identity(), ifDisplayHrefNotNull)
                .executeIfRecordsAdded();
    }

    private void addBannerToBannerAdditionTable(Collection<OldTextBanner> banners, DSLContext context) {
        List<BannerAddition> bannersAllAdditionsList = banners
                .stream()
                .filter(b -> !isEmpty(b.getCalloutIds()))
                .map(OldBannerAdditionsRepository::extractCalloutAdditions)
                .flatMap(List::stream)
                .collect(Collectors.toList());
        bannerAdditionsRepository.addOrUpdateBannerAdditions(context, bannersAllAdditionsList);
    }

    private void addBannerToBannerLogosTable(Collection<OldTextBanner> banners, DSLContext context) {
        bannerLogosRepository.update(context, filterList(banners, b -> b.getLogoImageHash() != null));
    }

    private void addBannerToBannerButtonsTable(Collection<OldTextBanner> banners, DSLContext context) {
        List<OldBannerButton> buttons = filterAndMapList(banners, b -> b.getButtonAction() != null, this::toBannerButton);
        bannerButtonsRepository.update(context, buttons);
    }

    private OldBannerButton toBannerButton(OldBannerWithButton banner) {
        return new OldBannerButton()
                .withBannerId(banner.getId())
                .withAction(banner.getButtonAction())
                .withCaption(banner.getButtonCaption())
                .withHref(banner.getButtonHref())
                .withStatusModerate(banner.getButtonStatusModerate());
    }

    @Override
    public OldTextBanner createBannerFromRecord(Record record) {
        OldTextBanner banner = textBannerMapper.fromDb(record);

        if (bannerImageMapper.canReadAtLeastOneProperty(record.fields())) {
            OldBannerImage bannerImage = bannerImageMapper.fromDb(record);
            if (bannerImage.getId() != null) {
                banner.withBannerImage(bannerImage);
            }
        }

        OldBannerTurboLandingParams turboLandingParams = bannerTurboLandingParamsMapper.fromDb(record);
        if (turboLandingParams.getBannerId() != null) {
            banner.withTurboLandingParams(turboLandingParams);
        }

        OldBannerPrice bannerPrice = bannerPriceMapper.fromDb(record);
        if (bannerPrice.getPrice() != null) {
            banner.withBannerPrice(bannerPrice);
        }

        return banner;
    }

    private static AddOrUpdateAndDeleteContainer<OldTextBanner> prepareBannerTurboGalleryUpdateContainer(
            Collection<AppliedChanges<OldTextBanner>> appliedChangesCollection) {
        final AddOrUpdateAndDeleteContainer<OldTextBanner>
                turboGalleryUpdateContainer = new AddOrUpdateAndDeleteContainer<>();

        for (AppliedChanges<OldTextBanner> ac : appliedChangesCollection) {
            if (ac.changed(OldTextBanner.TURBO_GALLERY_HREF)) {
                if (ac.getNewValue(OldTextBanner.TURBO_GALLERY_HREF) == null) {
                    turboGalleryUpdateContainer.markForDeletion(ac.getModel());
                } else {
                    turboGalleryUpdateContainer.markForAddOrUpdate(ac.getModel());
                }
            }
        }

        return turboGalleryUpdateContainer;
    }

    private AddOrUpdateAndDeleteContainer<OldTextBanner> prepareBannerPricesUpdateContainer(
            Collection<AppliedChanges<OldTextBanner>> appliedChangesCollection) {
        AddOrUpdateAndDeleteContainer<OldTextBanner> bannerPricesContainer = new AddOrUpdateAndDeleteContainer<>();

        for (AppliedChanges<OldTextBanner> ac : appliedChangesCollection) {
            if (ac.changed(OldTextBanner.BANNER_PRICE) && !Objects.equals(ac.getOldValue(OldTextBanner.BANNER_PRICE),
                    ac.getNewValue(OldTextBanner.BANNER_PRICE))) {
                if (ac.getNewValue(OldTextBanner.BANNER_PRICE) == null) {
                    bannerPricesContainer.markForDeletion(ac.getModel());
                } else {
                    bannerPricesContainer.markForAddOrUpdate(ac.getModel());
                }
            }
        }
        return bannerPricesContainer;
    }

    private List<OldTextBanner> getChangedPriceBanners(
            Collection<AppliedChanges<OldTextBanner>> appliedChangesCollection) {
        List<OldTextBanner> bannersWithChangedPrice = new ArrayList<>();

        for (AppliedChanges<OldTextBanner> ac : appliedChangesCollection) {
            if (ac.changed(OldTextBanner.BANNER_PRICE) && !Objects.equals(ac.getOldValue(OldTextBanner.BANNER_PRICE),
                    ac.getNewValue(OldTextBanner.BANNER_PRICE))) {
                if (ac.getNewValue(OldTextBanner.BANNER_PRICE) == null || ac.getOldValue(OldTextBanner.BANNER_PRICE) == null) {
                    bannersWithChangedPrice.add(ac.getModel());
                }
            }
        }
        return bannersWithChangedPrice;
    }

    private List<AppliedChanges<OldTextBanner>> getChangesForPriceBanners(
            Collection<AppliedChanges<OldTextBanner>> appliedChangesCollection) {
        List<AppliedChanges<OldTextBanner>> bannersWithChangedPrice = new ArrayList<>();

        for (AppliedChanges<OldTextBanner> ac : appliedChangesCollection) {
            if (ac.changed(OldTextBanner.BANNER_PRICE) && !Objects.equals(ac.getOldValue(OldTextBanner.BANNER_PRICE),
                    ac.getNewValue(OldTextBanner.BANNER_PRICE))) {
                if (ac.getNewValue(OldTextBanner.BANNER_PRICE) == null || ac.getOldValue(OldTextBanner.BANNER_PRICE) == null) {
                    bannersWithChangedPrice.add(ac);
                }
            }
        }
        return bannersWithChangedPrice;
    }

    @Override
    public Stream<OldTextBanner> createBannersFromRecordsWithAdditionsAttached(int shard, Collection<Record> records) {
        List<OldTextBanner> banners = records.stream().map(this::createBannerFromRecord).collect(toList());

        // достаем уточнения
        Set<Long> bannerIds = listToSet(banners, OldTextBanner::getId);
        Map<Long, List<Long>> bannerIdToCalloutIds =
                bannerAdditionsRepository.getCalloutIdsByBannerIds(shard, bannerIds);

        return banners.stream().peek(banner ->
                banner.withCalloutIds(defaultIfNull(bannerIdToCalloutIds.get(banner.getId()), emptyList())));
    }
}
