package ru.yandex.direct.core.entity.banner.repository.old.type;

import java.util.Collection;
import java.util.stream.Stream;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Field;
import org.jooq.Record;

import ru.yandex.direct.common.jooqmapper.OldJooqMapper;
import ru.yandex.direct.core.entity.banner.model.old.OldBanner;
import ru.yandex.direct.core.entity.banner.model.old.OldBannerType;
import ru.yandex.direct.model.AppliedChanges;

/**
 *
 * @param <B> тип баннера.
 */
@ParametersAreNonnullByDefault
@Deprecated
public interface OldBannerRepositoryTypeSupport<B extends OldBanner> {

    /**
     * @return Тип баннера, с которой работает данная реализация.
     */
    OldBannerType getType();

    /**
     * @return Поля таблицы, для которых заданы мапперы с включенным чтением из базы данных.
     * @see OldJooqMapper#getFieldsToRead
     */
    @SuppressWarnings("squid:S1452")
    Collection<Field<?>> getAllFields();

    /**
     * Выполнить добавление баннеров в БД.
     * <ol>
     * <li>Подготовить связанные сущности к добавлению баннеров.</li>
     * <li>Разложить модели в базу, используя маппинги для соответствующего типа.</li>
     * <li>Обновить связанные сущности.</li>
     * </ol>
     *  @param shard                 шард
     *
     * @param banners баннеры
     */
    void add(int shard, Collection<B> banners);

    /**
     * Обновить баннеры в БД.
     *
     * @param shard          шард
     * @param appliedChanges изменения моделей
     */
    void update(int shard, Collection<AppliedChanges<B>> appliedChanges);

    /**
     * Создать инстанс модели на основе записи в таблице.
     * Контроль полноты информации в передаваемой записи {@link Record} –
     * в зоне ответственности вызывающего кода.
     *
     * @param record запись в БД, содержащая данные для построения инстанса модели
     * @return Модель типа, соответствующего реализации {@link OldBannerRepositoryTypeSupport}.
     */
    B createBannerFromRecord(Record record);

    /**
     * Создать модели на основе записей таблицы, сходить за дополнениями в соответствующий репозиторий
     * и обогатить инстансы баннеров ими.
     *
     * @param shard   шард
     * @param records записи БД, содержащие данные для построения моделей
     * @return Баннеры с дополнениями
     */
    Stream<B> createBannersFromRecordsWithAdditionsAttached(int shard, Collection<Record> records);

    /**
     * Обновить geoFlag у баннеров
     *
     * @param shard          шард
     * @param appliedChanges список изменений баннеров
     */
    void updateGeoFlag(int shard, Collection<AppliedChanges<B>> appliedChanges);

}
