package ru.yandex.direct.core.entity.banner.repository.old.type;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import org.jooq.Field;
import org.jooq.Record;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.old.OldBanner;
import ru.yandex.direct.core.entity.banner.model.old.OldBannerType;
import ru.yandex.direct.dbschema.ppc.enums.BannersBannerType;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.core.entity.banner.repository.old.type.OldBannerTypeAssertionsMap.assertBannerHasConsistentType;
import static ru.yandex.direct.dbschema.ppc.tables.Banners.BANNERS;

/**
 * Диспетчер, помогающий сопоставить баннеры с обработчиками, соответствующими их типам.
 *
 * @see OldBannerRepositoryTypeSupport
 */
@Component
@ParametersAreNonnullByDefault
@Deprecated
public class OldBannerRepositoryTypeSupportFacade {

    private static final OldBannerRepositoryTypeSupport<OldBanner> READ_ONLY_STUB = new OldBannerRepositoryTypeSupportStub();
    private final Map<OldBannerType, OldBannerRepositoryTypeSupport> typeSupportMap;

    @Autowired
    public OldBannerRepositoryTypeSupportFacade(List<OldBannerRepositoryTypeSupport> typeSupportList) {
        this.typeSupportMap = Maps.uniqueIndex(typeSupportList, OldBannerRepositoryTypeSupport::getType);
    }

    /**
     * Сгруппировать баннеры по обработчикам баннеров конкретного типа,
     * получить результат в виде стрима таких групп.
     *
     * @param banners коллекция баннеров, в общем случае – различных типов.
     * @param <B>     тип баннеров
     * @return {@link Multimap}: ключ – обработчик, некоторая реализация {@link OldBannerRepositoryTypeSupport},
     * значения – баннеры (части входной коллекции), соответствующие ему.
     */
    @SuppressWarnings("WeakerAccess")
    public <B extends OldBanner> Multimap<OldBannerRepositoryTypeSupport<B>, B> groupByTypeSupports(Collection<B> banners) {
        return Multimaps.index(banners, this::getTypeSupport);
    }

    /**
     * Сгруппировать изменения по обработчикам баннеров конкретного типа,
     * получить результат в виде стрима таких групп.
     *
     * @param appliedChangesCollection коллекция изменений, производимых над баннерами
     *                                 в общем случае – различных типов.
     * @param <B>                      тип баннеров
     * @return {@link Multimap}: ключ – обработчик, некоторая реализация {@link OldBannerRepositoryTypeSupport},
     * значения – изменения над баннерами конкретного типа (части входной коллекции), соответствующие ему.
     */
    @SuppressWarnings("WeakerAccess")
    public <B extends OldBanner> Multimap<OldBannerRepositoryTypeSupport<B>, AppliedChanges<B>> groupChangesByTypeSupports(
            Collection<AppliedChanges<B>> appliedChangesCollection) {
        return Multimaps.index(appliedChangesCollection, this::getTypeSupport);
    }

    /**
     * Сгруппировать записи БД по типам баннеров.
     * В записях должно присутствовать поле {@link ru.yandex.direct.dbschema.ppc.tables.Banners#BANNER_TYPE}.
     *
     * @param records коллекция записей таблицы ppc.banners
     * @return {@link Multimap}: {@code {тип баннера -> соотв. записи}}.
     */
    public Multimap<OldBannerType, Record> groupRecordsByTypes(Collection<Record> records) {
        return Multimaps.index(records, this::getBannerType);
    }

    @SuppressWarnings({"unused", "squid:S1452"})
    public Collection<Field<?>> getAllFields(OldBanner banner) {
        return getTypeSupport(banner).getAllFields();
    }

    @SuppressWarnings("squid:S1452")
    public Collection<Field<?>> getAllBannerFields() {
        Collection<Field<?>> result = new LinkedHashSet<>();
        for (OldBannerRepositoryTypeSupport<?> typeSupport : typeSupportMap.values()) {
            result.addAll(typeSupport.getAllFields());
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    public <B extends OldBanner> OldBannerRepositoryTypeSupport<B> getTypeSupport(Record record) {
        return getTypeSupport(getBannerType(record));
    }

    public OldBannerType getBannerType(Record record) {
        return OldBannerType.fromSource(record.get(BANNERS.BANNER_TYPE, BannersBannerType.class));
    }

    private <B extends OldBanner> OldBannerRepositoryTypeSupport<B> getTypeSupport(AppliedChanges<B> appliedChanges) {
        return getTypeSupport(appliedChanges.getModel());
    }

    private <B extends OldBanner> OldBannerRepositoryTypeSupport<B> getTypeSupport(B banner) {
        assertBannerHasConsistentType(banner);
        return getTypeSupport(banner.getBannerType());
    }

    @SuppressWarnings("unchecked")
    public <B extends OldBanner> OldBannerRepositoryTypeSupport<B> getTypeSupport(OldBannerType bannerType) {
        return typeSupportMap.getOrDefault(bannerType, READ_ONLY_STUB);
    }

}
