package ru.yandex.direct.core.entity.banner.repository.old.type;

import java.util.Collection;
import java.util.Objects;
import java.util.stream.Stream;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Field;
import org.jooq.Record;

import ru.yandex.direct.core.entity.banner.model.old.OldAbstractBanner;
import ru.yandex.direct.core.entity.banner.model.old.OldBanner;
import ru.yandex.direct.core.entity.banner.model.old.OldBannerType;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplier;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplierBuilder;
import ru.yandex.direct.model.AppliedChanges;

import static java.lang.String.format;
import static java.util.function.Function.identity;
import static java.util.stream.Collectors.joining;
import static java.util.stream.Collectors.toList;
import static ru.yandex.direct.core.entity.banner.repository.old.mapper.CommonBannerMapperProvider.getCommonBannerMapper;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

/**
 * Заглушка {@link OldBannerRepositoryTypeSupport} для баннеров неподдерживаемых типов.
 * Реализует только операции чтения, возвращая заглушку баннера.
 * Операции чтения не разрешаются.
 */
@ParametersAreNonnullByDefault
@Deprecated
public class OldBannerRepositoryTypeSupportStub implements OldBannerRepositoryTypeSupport<OldBanner> {

    private final Collection<Field<?>> allFields;
    private final JooqMapperWithSupplier<OldBannerStub> mapper;

    public OldBannerRepositoryTypeSupportStub() {
        this.mapper = JooqMapperWithSupplierBuilder.builder(getCommonBannerMapper(), OldBannerStub::new).build();
        this.allFields = mapList(mapper.getFieldsToRead(), identity());
    }

    @Override
    public OldBannerType getType() {
        return null;
    }

    @Override
    public Collection<Field<?>> getAllFields() {
        return allFields;
    }

    @Override
    public void add(int shard, Collection<OldBanner> banners) {
        throw unsupported(banners);
    }

    @Override
    public void update(int shard, Collection<AppliedChanges<OldBanner>> appliedChanges) {
        throw unsupportedChanges(appliedChanges);
    }

    @Override
    public OldBanner createBannerFromRecord(Record record) {
        return mapper.fromDb(record);
    }

    @Override
    public Stream<OldBanner> createBannersFromRecordsWithAdditionsAttached(int shard, Collection<Record> records) {
        return records.stream().map(this::createBannerFromRecord);
    }

    @Override
    public void updateGeoFlag(int shard, Collection<AppliedChanges<OldBanner>> appliedChanges) {
        throw unsupportedChanges(appliedChanges);
    }

    private static UnsupportedOperationException unsupportedChanges(Collection<AppliedChanges<OldBanner>> changes) {
        return unsupported(changes.stream().map(AppliedChanges::getModel).collect(toList()));
    }

    private static UnsupportedOperationException unsupported(Collection<OldBanner> banners) {
        String types = banners.stream()
                .map(b -> b == null ? null : b.getBannerType())
                .distinct()
                .map(Objects::toString)
                .collect(joining(", ", "[", "]"));
        return new UnsupportedOperationException(format("Banners of types %s are not supported in the repo", types));
    }

    /**
     * Заглушка баннера для операций чтения.
     */
    private static class OldBannerStub extends OldAbstractBanner {
        @Override
        public Object copy() {
            final OldBannerStub target = new OldBannerStub();
            return this.copyTo(target);
        }
    }

}
