package ru.yandex.direct.core.entity.banner.repository.old.type;

import java.util.EnumMap;
import java.util.Map;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.Maps;

import ru.yandex.direct.core.entity.banner.model.old.OldBanner;
import ru.yandex.direct.core.entity.banner.model.old.OldBannerType;
import ru.yandex.direct.core.entity.banner.model.old.OldContentPromotionBanner;
import ru.yandex.direct.core.entity.banner.model.old.OldCpcVideoBanner;
import ru.yandex.direct.core.entity.banner.model.old.OldCpmAudioBanner;
import ru.yandex.direct.core.entity.banner.model.old.OldCpmBanner;
import ru.yandex.direct.core.entity.banner.model.old.OldCpmGeoPinBanner;
import ru.yandex.direct.core.entity.banner.model.old.OldCpmIndoorBanner;
import ru.yandex.direct.core.entity.banner.model.old.OldCpmOutdoorBanner;
import ru.yandex.direct.core.entity.banner.model.old.OldDynamicBanner;
import ru.yandex.direct.core.entity.banner.model.old.OldImageBanner;
import ru.yandex.direct.core.entity.banner.model.old.OldInternalBanner;
import ru.yandex.direct.core.entity.banner.model.old.OldMcBanner;
import ru.yandex.direct.core.entity.banner.model.old.OldMobileAppBanner;
import ru.yandex.direct.core.entity.banner.model.old.OldPerformanceBanner;
import ru.yandex.direct.core.entity.banner.model.old.OldTextBanner;

import static com.google.common.base.Preconditions.checkState;

@ParametersAreNonnullByDefault
@Deprecated
public class OldBannerTypeAssertionsMap {

    private static final Map<OldBannerType, Class<? extends OldBanner>> classByType;

    static {
        Map<OldBannerType, Class<? extends OldBanner>> init = new EnumMap<>(OldBannerType.class);

        init.put(OldBannerType.TEXT, OldTextBanner.class);
        init.put(OldBannerType.IMAGE_AD, OldImageBanner.class);
        init.put(OldBannerType.DYNAMIC, OldDynamicBanner.class);
        init.put(OldBannerType.MOBILE_CONTENT, OldMobileAppBanner.class);
        init.put(OldBannerType.CPC_VIDEO, OldCpcVideoBanner.class);
        init.put(OldBannerType.CPM_BANNER, OldCpmBanner.class);
        init.put(OldBannerType.CPM_OUTDOOR, OldCpmOutdoorBanner.class);
        init.put(OldBannerType.CPM_INDOOR, OldCpmIndoorBanner.class);
        init.put(OldBannerType.CPM_AUDIO, OldCpmAudioBanner.class);
        init.put(OldBannerType.CPM_GEO_PIN, OldCpmGeoPinBanner.class);
        init.put(OldBannerType.INTERNAL, OldInternalBanner.class);
        init.put(OldBannerType.PERFORMANCE, OldPerformanceBanner.class);
        init.put(OldBannerType.CONTENT_PROMOTION, OldContentPromotionBanner.class);
        init.put(OldBannerType.MCBANNER, OldMcBanner.class);

        classByType = Maps.immutableEnumMap(init);
    }

    /**
     * Проверить, соответствует ли указанный тип баннера (свойство {@link OldBanner#BANNER_TYPE})
     * классу переданного объекта.
     * <p>
     * Нужно не для настоящей валидации, а скорее для внутренних проверок
     * и раннего обнаружения ошибок при разработке и тестировании.
     * Если этот метод выстрелил, значит ошибка скорее всего где-то в коде сервиса,
     * или соответствующую entry не занесли в мапу {@link #classByType}.
     *
     * @param banner баннер
     * @param <B>    тип модели
     */
    public static <B extends OldBanner> void assertBannerHasConsistentType(B banner) {
        Class<?> validClass = validClassOf(banner);
        checkState(validClass != null, "No class specified for banner of type %s", banner.getBannerType());
        checkState(validClass.isAssignableFrom(banner.getClass()),
                "Banner.bannerType does not match class of the banner object:%n%s", banner);
    }

    @Nullable
    private static <B extends OldBanner> Class<? extends OldBanner> validClassOf(B banner) {
        return classByType.get(banner.getBannerType());
    }

    private OldBannerTypeAssertionsMap() {
        // no instantiation
    }
}
