package ru.yandex.direct.core.entity.banner.repository.old.type;

import java.util.Collection;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.banner.model.old.OldBannerImage;
import ru.yandex.direct.core.entity.banner.model.old.OldBannerWithBannerImage;
import ru.yandex.direct.core.entity.banner.repository.old.container.AddOrUpdateAndDeleteContainer;
import ru.yandex.direct.model.AppliedChanges;

@ParametersAreNonnullByDefault
@Deprecated
class OldBannerWithBannerImageSupport {
    private OldBannerWithBannerImageSupport() {
    }

    /**
     * Разделить баннеры на те, у которых требуется удалить {@link OldBannerWithBannerImage#BANNER_IMAGE},
     * и те, которым нужно добавить или обновить.
     *
     * @param appliedChangesCollection коллекция изменений, применяемых к баннерам.
     * @return DTO, содержащий два множества баннеров, {@link AddOrUpdateAndDeleteContainer}.
     */
    static <B extends OldBannerWithBannerImage> AddOrUpdateAndDeleteContainer<B> prepareBannerImagesUpdateContainer(
            Collection<AppliedChanges<B>> appliedChangesCollection) {
        final AddOrUpdateAndDeleteContainer<B>
                bannerImagesUpdateContainer = new AddOrUpdateAndDeleteContainer<>();

        for (AppliedChanges<B> appliedChanges : appliedChangesCollection) {
            if (appliedChanges.deleted(B.BANNER_IMAGE)) {
                bannerImagesUpdateContainer.markForDeletion(appliedChanges.getModel());
            } else if (isBannerImageChanged(appliedChanges)) {
                bannerImagesUpdateContainer.markForAddOrUpdate(appliedChanges.getModel());
            }
        }
        return bannerImagesUpdateContainer;
    }

    public static boolean isBannerImageChanged(@Nonnull AppliedChanges<? extends OldBannerWithBannerImage> ac) {
        return isBannerImageChanged(ac.getOldValue(OldBannerWithBannerImage.BANNER_IMAGE),
                ac.getNewValue(OldBannerWithBannerImage.BANNER_IMAGE));
    }

    public static boolean isBannerImageChanged(@Nullable OldBannerImage oldImage, @Nullable OldBannerImage newImage) {
        boolean imageChanged;
        if (oldImage == null && newImage == null) {
            imageChanged = false;
        } else if (oldImage != null && newImage != null) {
            imageChanged = !newImage.getImageHash().equals(oldImage.getImageHash());
            imageChanged = imageChanged ||
                    (newImage.getStatusModerate() != null
                            && newImage.getStatusModerate() != oldImage.getStatusModerate());
        } else {
            imageChanged = true;
        }
        return imageChanged;
    }
}
