package ru.yandex.direct.core.entity.banner.repository.old.type;

import java.util.Collection;
import java.util.List;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.BannerAddition;
import ru.yandex.direct.core.entity.banner.model.old.OldBannerWithCallouts;
import ru.yandex.direct.core.entity.banner.repository.old.container.CalloutsUpdateContainer;
import ru.yandex.direct.model.AppliedChanges;

import static java.util.function.Function.identity;
import static ru.yandex.direct.core.entity.banner.repository.old.OldBannerAdditionsRepository.extractCalloutAdditions;
import static ru.yandex.direct.utils.FunctionalUtils.filterList;
import static ru.yandex.direct.utils.FunctionalUtils.listToSet;

/**
 * Общая логика обработки баннеров с дополнениями в операциях репозитория.
 * Делегат для наследников {@link OldBannerRepositoryTypeSupport},
 * работающих с объявлениями, которые могут содержать дополнения (например, {@link ru.yandex.direct.core.entity.addition.callout.model.Callout}).
 *
 * @see OldBannerRepositoryTextTypeSupport
 * @see OldBannerRepositoryDynamicTypeSupport
 * @see OldBannerRepositoryTypeSupport
 */
@Component
@ParametersAreNonnullByDefault
@Deprecated
class OldBannerWithCalloutsSupport {

    /**
     * Подготовить список дополнений ({@link BannerAddition}) к добавлению и обновлению,
     * а также дополнения, которые следует удалить (отвязать от своих баннеров).
     *
     * @param appliedChangesCollection коллекция изменений, применяемых к баннерам.
     * @return DTO, содержащий необходимую информацию для обновления/удаления
     * дополнений, {@link CalloutsUpdateContainer}.
     */
    <B extends OldBannerWithCallouts> CalloutsUpdateContainer prepareCalloutsUpdateContainer(
            Collection<AppliedChanges<B>> appliedChangesCollection) {
        final CalloutsUpdateContainer updateContainer = new CalloutsUpdateContainer();

        for (AppliedChanges<B> ac : appliedChangesCollection) {
            if (!ac.changed(B.CALLOUT_IDS)) {
                continue;
            }
            List<BannerAddition> newCallouts = extractCalloutAdditions(ac.getModel());
            Set<BannerAddition> oldCallouts =
                    listToSet(extractCalloutAdditions(ac.getModel().getId(), ac.getOldValue(B.CALLOUT_IDS)),
                            identity());
            Set<Long> newCalloutIds = listToSet(newCallouts, BannerAddition::getId);

            List<BannerAddition> bannerCalloutToAddOrUpdate =
                    filterList(newCallouts, newCallout -> !oldCallouts.contains(newCallout));

            List<BannerAddition> bannerCalloutsToDelete = filterList(oldCallouts,
                    oldCallout -> !newCalloutIds.contains(oldCallout.getId()));

            updateContainer.markForAddOuUpdate(bannerCalloutToAddOrUpdate);
            updateContainer.markCalloutsForDeletion(ac.getModel(), bannerCalloutsToDelete);
        }

        return updateContainer;
    }

}
