package ru.yandex.direct.core.entity.banner.repository.old.type;

import java.io.IOException;
import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.databind.JsonNode;
import org.jooq.Configuration;
import org.jooq.impl.DSL;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.old.OldBannerMeasurer;
import ru.yandex.direct.core.entity.banner.model.old.OldBannerWithMeasurers;
import ru.yandex.direct.core.entity.banner.repository.old.OldBannerMeasurersRepository;
import ru.yandex.direct.model.AppliedChanges;

import static java.util.stream.Collectors.toList;
import static ru.yandex.direct.utils.JsonUtils.getObjectMapper;

@Component
@ParametersAreNonnullByDefault
@Deprecated
class OldBannerWithMeasurersSupport {

    private final OldBannerMeasurersRepository bannerMeasurersRepository;

    @Autowired
    OldBannerWithMeasurersSupport(
            OldBannerMeasurersRepository bannerMeasurersRepository) {
        this.bannerMeasurersRepository = bannerMeasurersRepository;
    }

    <B extends OldBannerWithMeasurers> void addMeasurers(Collection<B> banners, int shard) {
        var bannersMeasurers = banners.stream()
                .filter(b -> b.getMeasurers() != null && !b.getMeasurers().isEmpty())
                .map(b -> b.getMeasurers()
                        .stream()
                        .map(m -> new OldBannerMeasurer()
                                .withBannerId(b.getId())
                                .withBannerMeasurerSystem(m.getBannerMeasurerSystem())
                                .withParams(parseParams(m))
                                .withHasIntegration(m.getHasIntegration()))
                        .collect(toList()))
                .flatMap(Collection::stream)
                .collect(toList());
        bannerMeasurersRepository.addBannerMeasurers(shard, bannersMeasurers);
    }

    <B extends OldBannerWithMeasurers> void updateMeasurers(Collection<AppliedChanges<B>> appliedChanges,
                                                            Configuration ctx) {
        var bannersIds = appliedChanges.stream().map(c -> c.getModel().getId()).collect(toList());
        bannerMeasurersRepository.deleteBannersMeasurers(DSL.using(ctx), bannersIds);

        var bannersMeasurers = appliedChanges.stream()
                .filter(b -> b.getModel().getMeasurers() != null && !b.getModel().getMeasurers().isEmpty())
                .map(b -> b.getModel().getMeasurers()
                        .stream()
                        .map(m -> new OldBannerMeasurer()
                                .withBannerId(b.getModel().getId())
                                .withBannerMeasurerSystem(m.getBannerMeasurerSystem())
                                .withParams(parseParams(m))
                                .withHasIntegration(m.getHasIntegration()))
                        .collect(toList()))
                .flatMap(Collection::stream)
                .collect(toList());
        bannerMeasurersRepository.addBannerMeasurers(DSL.using(ctx), bannersMeasurers);
    }

    private static String parseParams(OldBannerMeasurer m) {
        String params = null;
        // исключения тут быть не может, валидность json-а проверяется выше в валидаторе
        try {
            JsonNode jsonNode = getObjectMapper().readTree(m.getParams());
            if (jsonNode != null) {
                params = jsonNode.toString();
            } else {
                params = null;
            }
        } catch (IOException ignored) {
        }
        return params;
    }
}
