package ru.yandex.direct.core.entity.banner.repository.old.type;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.Sets;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;

import ru.yandex.altay.model.language.LanguageOuterClass;
import ru.yandex.direct.core.entity.banner.model.old.OldBanner;
import ru.yandex.direct.core.entity.banner.model.old.OldBannerWithOrganization;
import ru.yandex.direct.core.entity.banner.repository.BannerRelationsRepository;
import ru.yandex.direct.core.entity.campaign.model.MetrikaCounter;
import ru.yandex.direct.core.entity.campaign.repository.CampMetrikaCountersRepository;
import ru.yandex.direct.core.entity.campaign.service.CampMetrikaCountersService;
import ru.yandex.direct.core.entity.clientphone.repository.ClientPhoneRepository;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.core.entity.organizations.repository.OrganizationRepository;
import ru.yandex.direct.core.entity.organizations.service.OrganizationService;
import ru.yandex.direct.core.entity.organizations.util.PermalinkUtils;
import ru.yandex.direct.dbutil.QueryWithForbiddenShardMapping;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.feature.FeatureName;
import ru.yandex.direct.model.AppliedChanges;

import static java.util.Collections.emptySet;
import static ru.yandex.direct.feature.FeatureName.ADDING_ORGANIZATIONS_COUNTERS_TO_CAMPAIGN_ON_ADDING_ORGANIZATIONS_TO_ADS;
import static ru.yandex.direct.feature.FeatureName.IS_ENABLE_PREFER_V_CARD_OVER_PERMALINK;
import static ru.yandex.direct.organizations.swagger.OrganizationsClient.getLanguageByName;
import static ru.yandex.direct.utils.FunctionalUtils.filterList;
import static ru.yandex.direct.utils.FunctionalUtils.flatMap;
import static ru.yandex.direct.utils.FunctionalUtils.flatMapToSet;
import static ru.yandex.direct.utils.FunctionalUtils.listToMap;
import static ru.yandex.direct.utils.FunctionalUtils.listToSet;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@Component
@ParametersAreNonnullByDefault
@Deprecated
public class OldBannerWithOrganizationSupport {

    private final OrganizationRepository organizationRepository;
    private final ClientPhoneRepository clientPhoneRepository;
    private final BannerRelationsRepository bannerRelationsRepository;
    private final CampMetrikaCountersRepository campMetrikaCountersRepository;

    private final OrganizationService organizationService;
    private final FeatureService featureService;
    private final ShardHelper shardHelper;

    @Autowired
    public OldBannerWithOrganizationSupport(OrganizationRepository organizationRepository,
                                            ClientPhoneRepository clientPhoneRepository,
                                            BannerRelationsRepository bannerRelationsRepository,
                                            CampMetrikaCountersRepository campMetrikaCountersRepository,
                                            OrganizationService organizationService,
                                            FeatureService featureService, ShardHelper shardHelper) {
        this.organizationRepository = organizationRepository;
        this.clientPhoneRepository = clientPhoneRepository;
        this.bannerRelationsRepository = bannerRelationsRepository;
        this.campMetrikaCountersRepository = campMetrikaCountersRepository;
        this.organizationService = organizationService;
        this.featureService = featureService;
        this.shardHelper = shardHelper;
    }

    void linkOrganizationsToBanners(DSLContext context, Collection<? extends OldBannerWithOrganization> banners) {
        Set<Long> bannerIdsWithEnabledPreferVCardOverPermalink =
                getBannerIdsForClientsWithFeature(IS_ENABLE_PREFER_V_CARD_OVER_PERMALINK,
                        StreamEx.of(banners).map(OldBanner::getId).toList());
        organizationRepository.linkOrganizationsToBanners(context, banners,
                bannerIdsWithEnabledPreferVCardOverPermalink);
    }

    void linkPhoneIdsToBanners(DSLContext context, Collection<? extends OldBannerWithOrganization> banners) {
        List<? extends OldBannerWithOrganization> bannersWithPhone = StreamEx.of(banners)
                .filter(b -> b.getPhoneId() != null)
                .toList();
        if (!bannersWithPhone.isEmpty()) {
            Map<Long, Long> phoneIdByBannerId = listToMap(bannersWithPhone, OldBannerWithOrganization::getId,
                    OldBannerWithOrganization::getPhoneId);
            clientPhoneRepository.linkBannerPhones(context, phoneIdByBannerId);
        }
    }

    /**
     * Обновляет привязки баннеров к организациям Справочника.
     * <p>
     * Выглядит так, что должно быть на уровне service,
     * т.к. организации напрямую не относятся к баннерам
     */
    public <B extends OldBannerWithOrganization> void updateBannerPermalinks(
            DSLContext dslContext,
            Collection<AppliedChanges<B>> appliedChanges) {

        // актуальные организации баннеров
        Map<Long, Long> permalinkIdByBannerId = StreamEx.of(appliedChanges)
                .filter(ac -> ac.changedAndNotDeleted(OldBannerWithOrganization.PERMALINK_ID))
                .mapToEntry(ac -> ac.getModel().getId(), ac -> ac.getNewValue(OldBannerWithOrganization.PERMALINK_ID))
                .toMap();

        // банеры, у которых пермалинк поменялся и старый (если он есть) нужно удалить
        List<Long> changedPermalinkBannerIds = StreamEx.of(appliedChanges)
                .filter(ac -> ac.changed(OldBannerWithOrganization.PERMALINK_ID))
                .map(ac -> ac.getModel().getId())
                .distinct()
                .toList();


        // актуальные подменные номера баннеров
        Map<Long, Long> phoneIdByBannerId = StreamEx.of(appliedChanges)
                .filter(this::isBannerPhoneIdActuallyChanged)
                .mapToEntry(ac -> ac.getModel().getId(), ac -> ac.getNewValue(OldBannerWithOrganization.PHONE_ID))
                .nonNullValues()
                .toMap();

        // Id баннеров, у которых нужно удалить phoneId
        List<Long> bannerIdToDeletePhoneIds = StreamEx.of(appliedChanges)
                .filter(ac -> ac.deleted(OldBannerWithOrganization.PHONE_ID))
                .map(ac -> ac.getModel().getId())
                .toList();


        // банеры, у которых флаг (приоритет визитки над пермалинком) должен быть включен (без учета проверки фичи)
        Set<Long> bannerIdsWithVCardPreferFlag = new HashSet<>(StreamEx.of(appliedChanges)
                .map(AppliedChanges::getModel)
                .filter(PermalinkUtils::calculatePreferVCardOverPermalink)
                .map(OldBanner::getId)
                .toSet());

        // банеры, у которых привязанная организация не изменилась, но значение флага
        // (приоритет визитки над пермалинком) должно измениться (из-за удаления визики или изменении флага)
        Map<Long, Boolean> preferVCardOverPermalinkFlagByBannerIds = new HashMap<>(StreamEx.of(appliedChanges)
                .filter(ac -> !ac.changed(OldBannerWithOrganization.PERMALINK_ID))
                .mapToEntry(
                        ac -> ac.getModel().getId(),
                        PermalinkUtils::getPreferVCardOverPermalinkUpdateValue
                )
                .nonNullValues()
                .toMap());

        // баннеры, у которых планируется менять значение флага (приоритет визитки над пермалинком)
        Set<Long> bannerIdsWithPreferVCardOverPermalinkFlagValue = new HashSet<>(bannerIdsWithVCardPreferFlag);
        bannerIdsWithPreferVCardOverPermalinkFlagValue.addAll(preferVCardOverPermalinkFlagByBannerIds.keySet());

        // баннеры, у которых планируется менять значение флага (приоритет визитки над пермалинком)
        // и для которых доступна фича
        Set<Long> bannerIdsWithEnabledPreferVCardOverPermalink =
                getBannerIdsForClientsWithFeature(IS_ENABLE_PREFER_V_CARD_OVER_PERMALINK,
                        List.copyOf(bannerIdsWithPreferVCardOverPermalinkFlagValue));
        bannerIdsWithVCardPreferFlag.retainAll(bannerIdsWithEnabledPreferVCardOverPermalink);
        preferVCardOverPermalinkFlagByBannerIds.keySet().retainAll(bannerIdsWithEnabledPreferVCardOverPermalink);

        organizationRepository.unlinkOrganizationsFromBanners(dslContext,
                changedPermalinkBannerIds);
        organizationRepository.linkOrganizationsToBanners(dslContext, permalinkIdByBannerId,
                bannerIdsWithVCardPreferFlag);
        clientPhoneRepository.linkBannerPhones(dslContext, phoneIdByBannerId);
        clientPhoneRepository.unlinkBannerPhonesByBannerId(dslContext, bannerIdToDeletePhoneIds);
        organizationRepository.updateOrganizationsToBannerBinds(dslContext, preferVCardOverPermalinkFlagByBannerIds);

        updateOrganizationCountersForBannersCampaignsWithEnabledFeature(dslContext, appliedChanges);
    }

    private <B extends OldBannerWithOrganization> boolean isBannerPhoneIdActuallyChanged(AppliedChanges<B> ac) {
        if (ac.changed(OldBannerWithOrganization.PHONE_ID)) {
            return ac.changedAndNotDeleted(OldBannerWithOrganization.PHONE_ID);
        }
        // Если изменилась только организация, но не телефон, то все равно нужно обновить телефон на баннере
        // на предыдущий, т.к. иначе он потеряется при отвязке предыдущей организации
        return ac.changed(OldBannerWithOrganization.PERMALINK_ID);
    }

    private <B extends OldBannerWithOrganization> void updateOrganizationCountersForBannersCampaignsWithEnabledFeature(DSLContext dslContext, Collection<AppliedChanges<B>> appliedChanges) {
        List<Long> bannerIds = mapList(appliedChanges, ac -> ac.getModel().getId());
        Set<Long> bannerIdsWithEnabledAddingOrganizationCounterToCampaign =
                getBannerIdsWithEnabledAddingOrganizationCounterToCampaign(bannerIds);

        Collection<AppliedChanges<B>> changesToUpdate = StreamEx.of(appliedChanges)
                .mapToEntry(changes -> changes.getModel().getId())
                .filterValues(bannerIdsWithEnabledAddingOrganizationCounterToCampaign::contains)
                .keys()
                .toList();

        updateOrgaizationsCountersForBannersCampaigns(dslContext, changesToUpdate);
    }

    /**
     * Получить для присланные id баннеров, доступна ли фича для их клиента, по которой включается автоматическое
     * добавление счетчиков метрики организаций
     */
    private Set<Long> getBannerIdsWithEnabledAddingOrganizationCounterToCampaign(List<Long> changedBannerIds) {
        return getBannerIdsForClientsWithFeature(ADDING_ORGANIZATIONS_COUNTERS_TO_CAMPAIGN_ON_ADDING_ORGANIZATIONS_TO_ADS, changedBannerIds);
    }

    @QueryWithForbiddenShardMapping("Используется только в тестах и BannersAddOperationOld")
    Set<Long> getBannerIdsForClientsWithFeature(FeatureName featureName, List<Long> changedBannerIds) {
        Map<Long, ClientId> clientIdByBannerId = EntryStream.zip(changedBannerIds,
                shardHelper.getClientIdsByBannerIds(changedBannerIds))
                .mapValues(ClientId::fromLong)
                .toMap();

        Map<ClientId, Boolean> isEnabledByClientId =
                featureService.isEnabledForClientIdsOnlyFromDb(Set.copyOf(clientIdByBannerId.values()),
                        featureName.getName());

        return EntryStream.of(clientIdByBannerId)
                .mapValues(isEnabledByClientId::get)
                .nonNullValues()
                .filterValues(Boolean::booleanValue)
                .keys()
                .toSet();
    }

    /**
     * При изменении организации у баннера обновляем счетчики на кампании
     */
    @Deprecated // менять синхронно с BannerWithOrganizationUpdateOperationTypeSupport
    private <B extends OldBannerWithOrganization> void updateOrgaizationsCountersForBannersCampaigns(
            DSLContext dslContext,
            Collection<AppliedChanges<B>> appliedChanges) {
        List<AppliedChanges<B>> bannerChangesShouldUpdateCampaignCounters = filterList(appliedChanges,
                this::shouldUpdateCampaignCounter);

        if (bannerChangesShouldUpdateCampaignCounters.isEmpty()) {
            return;
        }

        Set<Long> changingCampaignIds = listToSet(bannerChangesShouldUpdateCampaignCounters,
                ac -> ac.getModel().getCampaignId());

        Map<Long, Set<Long>> currentPermalinkIdsByCampaignId = getCurrentPermalinksByCampaignId(dslContext,
                changingCampaignIds);

        //на текущий момент не можем узнать напрямую источник счетчика метрики в кампании

        //на первом этапе вычисляем пермалинки, которые были сброшены при обновлении баннеров
        Map<Long, Set<Long>> deletingPermalinkIdsByCampaignId =
                getDeletingPermalinkIdsByCampaignId(bannerChangesShouldUpdateCampaignCounters,
                        currentPermalinkIdsByCampaignId);

        //для всех удаляющихся и добавляющиихся пермалинков получаем счетчики метрики
        Set<Long> permalinkIdsToFetchCounters = StreamEx.of(currentPermalinkIdsByCampaignId.values())
                .flatMap(StreamEx::of)
                .append(flatMapToSet(deletingPermalinkIdsByCampaignId.values(), Function.identity()))
                .toSet();

        Map<Long, Long> counterIdByPermalinkId = organizationService.getMetrikaCountersByOrganizationsIds(
                getLanguageByName(LocaleContextHolder.getLocale().getLanguage()).orElse(LanguageOuterClass.Language.EN),
                permalinkIdsToFetchCounters);

        Map<Long, List<MetrikaCounter>> actualMetrikaCounterByCampaignId = campMetrikaCountersRepository
                .getMetrikaCounterByCid(dslContext, changingCampaignIds);

        Map<Long, Set<Long>> actualMetrikaCounterIdsByCampaignId = EntryStream.of(actualMetrikaCounterByCampaignId)
                .mapValues(counters -> listToSet(counters, MetrikaCounter::getId))
                .toMap();

        Map<Long, Set<Long>> currentPermalinkCounterIdsByCampaignId =
                getCounterIdsByCampaignIdForPermalinksByCampaignId(
                        currentPermalinkIdsByCampaignId, counterIdByPermalinkId);

        //счетчики, которые принадлежали удаленным из баннеров пермалинкам нужно удалить, если у других баннеров не было
        //таких же организаций
        Map<Long, Set<Long>> deletingPermalinkCounterIdsByCampaignId =
                getCounterIdsByCampaignIdForPermalinksByCampaignId(
                        deletingPermalinkIdsByCampaignId, counterIdByPermalinkId);

        Map<Long, Set<Long>> newMetrikaCounterIdsByCampaignId = StreamEx.of(changingCampaignIds)
                .mapToEntry(cid -> getNewMetrikaCounterIds(
                        actualMetrikaCounterIdsByCampaignId.getOrDefault(cid, emptySet()),
                        deletingPermalinkCounterIdsByCampaignId.getOrDefault(cid, emptySet()),
                        currentPermalinkCounterIdsByCampaignId.getOrDefault(cid, emptySet())))
                .toMap();

        updateCampaignMetrikaCounters(dslContext, newMetrikaCounterIdsByCampaignId, actualMetrikaCounterByCampaignId,
                Set.copyOf(counterIdByPermalinkId.values()));
    }

    /**
     * При создании баннера с организацией добавляем к кампании счетчик организации
     */
    @Deprecated // менять синхронно с BannerWithOrganizationAddOperationTypeSupport
    public <B extends OldBannerWithOrganization> void addOrganizationCountersToBannersCampaigns(DSLContext dslContext,
                                                                                                Collection<B> banners) {

        Set<Long> enabledAddingOrganizationCounterToCampaignByBannerId =
                getBannerIdsWithEnabledAddingOrganizationCounterToCampaign(mapList(banners,
                        OldBannerWithOrganization::getId));

        List<B> bannersWithEnabledOrganizationCountersAdding = StreamEx.of(banners)
                .mapToEntry(OldBannerWithOrganization::getId)
                .filterValues(enabledAddingOrganizationCounterToCampaignByBannerId::contains)
                .keys()
                .toList();

        if (bannersWithEnabledOrganizationCountersAdding.isEmpty()) {
            return;
        }

        Set<Long> changingCampaignIds = listToSet(bannersWithEnabledOrganizationCountersAdding,
                OldBannerWithOrganization::getCampaignId);

        Map<Long, Set<Long>> addingPermalinkIdsByCampaignId = StreamEx.of(bannersWithEnabledOrganizationCountersAdding)
                .mapToEntry(OldBanner::getCampaignId, OldBannerWithOrganization::getPermalinkId)
                .nonNullValues()
                .sortedBy(Map.Entry::getKey)
                .collapseKeys()
                .mapValues(Set::copyOf)
                .toMap();

        List<Long> addingPermalinkIds = flatMap(addingPermalinkIdsByCampaignId.values(), Function.identity());

        Map<Long, Set<Long>> currentPermalinkIdsByCampaignId = getCurrentPermalinksByCampaignId(dslContext,
                changingCampaignIds);

        Set<Long> currentPermalinkIds = flatMapToSet(currentPermalinkIdsByCampaignId.values(), Function.identity());

        Set<Long> newPermalinkIds = StreamEx.of(currentPermalinkIds)
                .append(addingPermalinkIds)
                .toSet();

        Map<Long, Long> counterIdByPermalinkId = organizationService.getMetrikaCountersByOrganizationsIds(
                getLanguageByName(LocaleContextHolder.getLocale().getLanguage()).orElse(LanguageOuterClass.Language.EN),
                newPermalinkIds);


        Map<Long, Set<Long>> currentPermalinkCounterIdsByCampaignId = StreamEx.of(changingCampaignIds)
                .mapToEntry(cid -> Sets.union(addingPermalinkIdsByCampaignId.getOrDefault(cid, emptySet()),
                        currentPermalinkIdsByCampaignId.getOrDefault(cid, emptySet())))
                .mapValues(campaignPermalinkIds -> StreamEx.of(campaignPermalinkIds)
                        .map(counterIdByPermalinkId::get)
                        .nonNull()
                        .toSet())
                .toMap();


        Map<Long, List<MetrikaCounter>> actualMetrikaCounterByCampaignId = campMetrikaCountersRepository
                .getMetrikaCounterByCid(dslContext, changingCampaignIds);

        Map<Long, Set<Long>> actualMetrikaCounterIdsByCampaignId = EntryStream.of(actualMetrikaCounterByCampaignId)
                .mapValues(counters -> listToSet(counters,
                        MetrikaCounter::getId))
                .toMap();

        Map<Long, Set<Long>> newMetrikaCounterIdsByCampaignId = StreamEx.of(changingCampaignIds)
                .mapToEntry(cid -> getNewMetrikaCounterIds(
                        actualMetrikaCounterIdsByCampaignId.getOrDefault(cid, emptySet()),
                        emptySet(),
                        currentPermalinkCounterIdsByCampaignId.getOrDefault(cid, emptySet())))
                .toMap();

        Map<Long, List<MetrikaCounter>> countersByCampaignId =
                CampMetrikaCountersService.
                        calculateCountersByCampaignIdForNewMetrikaCounterIds(newMetrikaCounterIdsByCampaignId,
                                actualMetrikaCounterByCampaignId,
                                Set.copyOf(counterIdByPermalinkId.values()));

        campMetrikaCountersRepository.updateMetrikaCounters(dslContext, countersByCampaignId);
    }

    private <B extends OldBannerWithOrganization> boolean shouldUpdateCampaignCounter(AppliedChanges<B> ac) {
        return ac.changed(OldBannerWithOrganization.PERMALINK_ID);
    }

    private void updateCampaignMetrikaCounters(DSLContext dslContext,
                                               Map<Long, Set<Long>> newMetrikaCounterIdsByCampaignId,
                                               Map<Long, List<MetrikaCounter>> actualMetrikaCounterByCampaignId,
                                               Set<Long> organizationCounterIds) {
        List<Long> metrikaCounterCampaignIdsToDelete = EntryStream.of(newMetrikaCounterIdsByCampaignId)
                .filterValues(Set::isEmpty)
                .keys()
                .toList();

        campMetrikaCountersRepository.deleteMetrikaCounters(dslContext, metrikaCounterCampaignIdsToDelete);

        Map<Long, List<MetrikaCounter>> countersByCampaignId =
                CampMetrikaCountersService.
                        calculateCountersByCampaignIdForNewMetrikaCounterIds(newMetrikaCounterIdsByCampaignId,
                                actualMetrikaCounterByCampaignId,
                                organizationCounterIds);

        campMetrikaCountersRepository.updateMetrikaCounters(dslContext, countersByCampaignId);
    }

    private Map<Long, Set<Long>> getCurrentPermalinksByCampaignId(DSLContext dslContext,
                                                                  Set<Long> campaignIds) {
        Map<Long, List<Long>> allBannerIdsByUpdatingCampaignIds =
                bannerRelationsRepository.getBannerIdsByCampaignIdsMap(dslContext, campaignIds);

        List<Long> updatingCampaignsBannerIds = flatMap(allBannerIdsByUpdatingCampaignIds.values(),
                Function.identity());

        Map<Long, Long> permalinkIdByBannerId = organizationRepository.getPermalinkIdsByBannerIds(dslContext,
                updatingCampaignsBannerIds);

        return EntryStream.of(allBannerIdsByUpdatingCampaignIds)
                .mapValues(campaignBannerIds -> StreamEx.of(campaignBannerIds)
                        .map(permalinkIdByBannerId::get)
                        .nonNull()
                        .toSet())
                .toMap();
    }

    private static Map<Long, Set<Long>> getCounterIdsByCampaignIdForPermalinksByCampaignId(
            Map<Long, Set<Long>> permalinkIdsByCampaignId,
            Map<Long, Long> counterIdByPermalinkId) {
        return EntryStream.of(permalinkIdsByCampaignId)
                .mapValues(campaignPermalinkIds -> StreamEx.of(campaignPermalinkIds)
                        .map(counterIdByPermalinkId::get)
                        .nonNull()
                        .toSet())
                .toMap();
    }

    private static <B extends OldBannerWithOrganization> Map<Long, Set<Long>> getDeletingPermalinkIdsByCampaignId(
            Collection<AppliedChanges<B>> appliedChanges,
            Map<Long, Set<Long>> currentPermalinkIdsByCampaignId) {
        return StreamEx.of(appliedChanges)
                .mapToEntry(ac -> ac.getModel().getCampaignId(),
                        ac -> ac.getOldValue(OldBannerWithOrganization.PERMALINK_ID))
                .nonNullValues()
                .removeKeyValue((campaignId, permalinkId) -> currentPermalinkIdsByCampaignId.get(campaignId).contains(permalinkId))
                .sortedBy(Map.Entry::getKey)
                .collapseKeys()
                .mapValues(Set::copyOf)
                .toMap();
    }

    private static Set<Long> getNewMetrikaCounterIds(Set<Long> actualCounters, Set<Long> deletingCounters,
                                                     Set<Long> addingCounters) {
        return StreamEx.of(actualCounters)
                .remove(deletingCounters::contains)
                .append(addingCounters)
                .toSet();
    }

}
