package ru.yandex.direct.core.entity.banner.repository.old.type;

import java.util.Collection;
import java.util.List;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.old.OldBannerPixel;
import ru.yandex.direct.core.entity.banner.model.old.OldBannerWithPixels;
import ru.yandex.direct.core.entity.banner.repository.old.container.BannerPixelsUpdateContainer;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.core.entity.banner.repository.old.OldBannerPixelsRepository.extractBannerPixels;
import static ru.yandex.direct.utils.FunctionalUtils.filterList;
import static ru.yandex.direct.utils.FunctionalUtils.listToSet;

/**
 * Общая логика обработки баннеров с пикселями в операциях репозитория.
 */
@Component
@ParametersAreNonnullByDefault
@Deprecated
public class OldBannerWithPixelsSupport {

    /**
     * Подготовить список пикселей ({@link OldBannerPixel}) к добавлению,
     * а также пиксели, которые следует удалить (отвязать от своих баннеров).
     *
     * @param appliedChangesCollection коллекция изменений, применяемых к баннерам.
     * @return DTO, содержащий необходимую информацию для обновления
     * пикселей, {@link BannerPixelsUpdateContainer}.
     */
    <B extends OldBannerWithPixels> BannerPixelsUpdateContainer preparePixelsUpdateContainer(
            Collection<AppliedChanges<B>> appliedChangesCollection) {
        final BannerPixelsUpdateContainer updateContainer = new BannerPixelsUpdateContainer();

        for (AppliedChanges<B> ac : appliedChangesCollection) {
            if (!ac.changed(B.PIXELS)) {
                continue;
            }
            List<OldBannerPixel> newPixels = extractBannerPixels(ac.getModel());
            List<OldBannerPixel> oldPixels = extractBannerPixels(ac.getModel().getId(), ac.getOldValue(B.PIXELS));
            Set<String> newPixelUrls = listToSet(newPixels, OldBannerPixel::getPixelUrl);
            Set<String> oldPixelUrls = listToSet(oldPixels, OldBannerPixel::getPixelUrl);

            List<OldBannerPixel> bannerPixelsToAdd =
                    filterList(newPixels, newPixel -> !oldPixelUrls.contains(newPixel.getPixelUrl()));

            List<OldBannerPixel> bannerPixelsToDelete =
                    filterList(oldPixels, oldPixel -> !newPixelUrls.contains(oldPixel.getPixelUrl()));

            updateContainer.markForAdd(bannerPixelsToAdd);
            updateContainer.markPixelsForDeletion(ac.getModel(), bannerPixelsToDelete);
        }

        return updateContainer;
    }
}
