package ru.yandex.direct.core.entity.banner.repository.old.type;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.impl.DSL;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.old.OldBannerWithTurboLanding;
import ru.yandex.direct.core.entity.banner.repository.old.OldBannerTurbolandingParamsRepository;
import ru.yandex.direct.core.entity.banner.repository.old.container.AddOrUpdateAndDeleteContainer;
import ru.yandex.direct.core.entity.turbolanding.repository.TurboLandingRepository;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.core.entity.banner.service.old.BannerUtils.isBannerTurbolandingChanged;
import static ru.yandex.direct.core.entity.banner.service.old.BannerUtils.isBannerTurbolandingStatusModerateChanged;

@Component
@ParametersAreNonnullByDefault
@Deprecated
class OldBannerWithTurboLandingSupport {
    private final OldBannerTurbolandingParamsRepository bannerTurbolandingParamsRepository;
    private final TurboLandingRepository turboLandingRepository;

    @Autowired
    public OldBannerWithTurboLandingSupport(OldBannerTurbolandingParamsRepository bannerTurbolandingParamsRepository,
                                            TurboLandingRepository turboLandingRepository) {
        this.bannerTurbolandingParamsRepository = bannerTurbolandingParamsRepository;
        this.turboLandingRepository = turboLandingRepository;
    }

    /**
     * Разделить баннеры на те, у которых требуется удалить turboLanding,
     * и те, которым нужно добавить или обновить.
     *
     * @param appliedChangesCollection коллекция изменений, применяемых к баннерам.
     * @return DTO, содержащий два множества баннеров, {@link AddOrUpdateAndDeleteContainer}.
     */
    private <T extends OldBannerWithTurboLanding> AddOrUpdateAndDeleteContainer<T> prepareBannerTurboLandingsUpdateContainer(
            Collection<AppliedChanges<T>> appliedChangesCollection
    ) {
        final AddOrUpdateAndDeleteContainer<T> bannerTurbolandingUpdateContainer =
                new AddOrUpdateAndDeleteContainer<>();

        for (AppliedChanges<T> appliedChanges : appliedChangesCollection) {
            if (isBannerTurbolandingChanged(appliedChanges) ||
                    isBannerTurbolandingStatusModerateChanged(appliedChanges)) {
                if (appliedChanges.getNewValue(T.TURBO_LANDING_ID) == null) {
                    bannerTurbolandingUpdateContainer.markForDeletion(appliedChanges.getModel());
                } else {
                    bannerTurbolandingUpdateContainer.markForAddOrUpdate(appliedChanges.getModel());
                }
            }
        }
        return bannerTurbolandingUpdateContainer;
    }

    <T extends OldBannerWithTurboLanding> void updateAfterBannersAdded(Collection<T> banners, DSLContext dslContext) {
        turboLandingRepository.addBannerToBannerTurbolandingsTableOrUpdate(banners, dslContext);
        bannerTurbolandingParamsRepository.addOrUpdateBannerTurbolandingParams(banners, dslContext);
    }

    <T extends OldBannerWithTurboLanding> void updateTurbolandings(Collection<AppliedChanges<T>> appliedChanges,
                                                                   Configuration ctx) {
        //prepare banner turbolanding to update
        AddOrUpdateAndDeleteContainer<T> turboLandingsContainer =
                prepareBannerTurboLandingsUpdateContainer(appliedChanges);

        //удаление турболендингов
        turboLandingRepository.deleteBannerFromBannerTurboLandingsTable(turboLandingsContainer.getModelsToDelete(),
                DSL.using(ctx));
        //добавление и обновление турболендингов
        turboLandingRepository
                .addBannerToBannerTurbolandingsTableOrUpdate(turboLandingsContainer.getModelsToAddOrUpdate(),
                        DSL.using(ctx));
    }

    <T extends OldBannerWithTurboLanding> void updateTurbolandingParams(Collection<AppliedChanges<T>> appliedChanges,
                                                                        Configuration ctx) {
        // prepare banner turbolanding params to update
        AddOrUpdateAndDeleteContainer<T> turboLandingParamsContainer =
                bannerTurbolandingParamsRepository.prepareBannerTurboLandingParamsUpdateContainer(appliedChanges);

        // обновление параметров турболендингов баннера
        bannerTurbolandingParamsRepository.addOrUpdateBannerTurbolandingParams(
                turboLandingParamsContainer.getModelsToAddOrUpdate(), DSL.using(ctx));
        // удаление параметров турболендингов баннера
        bannerTurbolandingParamsRepository.deleteBannerTurbolandingParams(
                turboLandingParamsContainer.getModelsToDelete(), DSL.using(ctx));
    }
}
