package ru.yandex.direct.core.entity.banner.repository.type;

import java.util.Collection;
import java.util.Set;
import java.util.function.Function;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.ImmutableSet;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.TableField;

import ru.yandex.direct.core.entity.banner.container.BannerRepositoryContainer;
import ru.yandex.direct.core.entity.banner.model.Banner;
import ru.yandex.direct.dbschema.ppc.tables.records.BannersRecord;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.jooqmapperhelper.InsertHelperAggregator;
import ru.yandex.direct.jooqmapperhelper.UpdateHelperAggregator;
import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.model.ModelProperty;

import static ru.yandex.direct.dbschema.ppc.tables.Banners.BANNERS;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.direct.jooqmapper.read.ReaderBuilders.fromField;

/**
 * Абстрактный класс для реализации на базе него репозиторных тайп-саппортов конкретных ассетов.
 * <p>
 * Подходит для случая, когда интерфейс состоит из одного или двух полей (помимо id),
 * которые хранятся в основной таблице banners.
 *
 * @param <B> - интерфейс
 */
@ParametersAreNonnullByDefault
public abstract class AbstractBannerDefaultRepositoryTypeSupport<B extends Banner>
        extends AbstractBannerRepositoryTypeSupport<B> {

    private static final TableField<BannersRecord, Long> BANNERS_ID_FIELD = BANNERS.BID;
    private final Set<Field<?>> fieldSet;
    private final JooqMapper<B> jooqMapper;

    /**
     * Для репозитория из одного поля.
     *
     * @param <V> - тип поля в интерфейсе
     * @param <R> - jooq класс
     * @param <F> - тип поля в jooq классе
     */
    public <R extends Record, V, F> AbstractBannerDefaultRepositoryTypeSupport(
            DslContextProvider dslContextProvider,
            ModelProperty<? super B, V> modelProperty,
            TableField<R, F> field,
            Function<F, V> readConverter,
            Function<V, F> writeConverter) {

        super(dslContextProvider);
        this.fieldSet = ImmutableSet.of(field, BANNERS_ID_FIELD);
        this.jooqMapper = JooqMapperBuilder.<B>builder()
                .readProperty(Banner.ID, fromField(BANNERS_ID_FIELD))
                .map(convertibleProperty(modelProperty, field, readConverter::apply, writeConverter::apply))
                .build();
    }

    /**
     * Для репозитория из двух полей.
     */
    public <R extends Record, V, F, R2 extends Record, V2, F2> AbstractBannerDefaultRepositoryTypeSupport(
            DslContextProvider dslContextProvider,
            ModelProperty<? super B, V> modelProperty,
            TableField<R, F> field,
            Function<F, V> readConverter,
            Function<V, F> writeConverter,
            ModelProperty<? super B, V2> modelProperty2,
            TableField<R2, F2> field2,
            Function<F2, V2> readConverter2,
            Function<V2, F2> writeConverter2) {

        super(dslContextProvider);
        this.fieldSet = ImmutableSet.of(field, field2, BANNERS_ID_FIELD);

        this.jooqMapper = JooqMapperBuilder.<B>builder()
                .readProperty(Banner.ID, fromField(BANNERS_ID_FIELD))
                .map(convertibleProperty(modelProperty, field, readConverter::apply, writeConverter::apply))
                .map(convertibleProperty(modelProperty2, field2, readConverter2::apply, writeConverter2::apply))
                .build();
    }

    @Override
    public final Collection<Field<?>> getFields() {
        return fieldSet;
    }

    @Override
    public final <M extends B> void fillFromRecord(M model, Record record) {
        jooqMapper.fromDb(record, model);
    }

    @Override
    public final void enrichModelFromOtherTables(DSLContext dslContext, Collection<B> models) {
    }

    @Override
    public final void updateAdditionTables(DSLContext context, BannerRepositoryContainer container,
                                           Collection<AppliedChanges<B>> appliedChanges) {
    }

    @Override
    public final void insertToAdditionTables(DSLContext context, BannerRepositoryContainer container,
                                             Collection<B> models) {
    }

    @Override
    public final void pushToInsert(InsertHelperAggregator insertHelperAggregator, B model) {
        checkBeforeInsert(model);
        insertHelperAggregator.getOrCreate(BANNERS_ID_FIELD.getTable()).add(jooqMapper, model);
    }

    @Override
    public final void processUpdate(UpdateHelperAggregator updateHelperAggregator,
                                    Collection<AppliedChanges<B>> appliedChanges) {
        checkBeforeUpdate(appliedChanges);
        updateHelperAggregator.getOrCreate(BANNERS_ID_FIELD)
                .processUpdateAll(jooqMapper, appliedChanges);
    }

    /**
     * Используется для генерации исключения, если при вставке данных в базу они некорректны.
     * Можно использовать для критичных проверок, чтобы потенциальная ошибка валидации
     * не смогла привести к сохранению невалидных данных.
     */
    public void checkBeforeInsert(B model) {
    }

    /**
     * Используется для генерации исключения, если при обновлении данных в базе они некорректны.
     * Можно использовать для критичных проверок, чтобы потенциальная ошибка валидации
     * не смогла привести к сохранению невалидных данных.
     */
    public void checkBeforeUpdate(Collection<AppliedChanges<B>> appliedChanges) {
    }
}
