package ru.yandex.direct.core.entity.banner.repository.type;

import java.util.Collection;
import java.util.Map;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jetbrains.annotations.NotNull;

import ru.yandex.direct.core.entity.banner.container.BannerRepositoryContainer;
import ru.yandex.direct.core.entity.banner.container.BannersOperationContainer;
import ru.yandex.direct.core.entity.banner.model.Banner;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.direct.multitype.repository.AbstractRepositoryTypeSupport;
import ru.yandex.grut.objects.proto.client.Schema;

import static java.util.Collections.emptyMap;
import static java.util.Collections.emptySet;

@ParametersAreNonnullByDefault
public abstract class AbstractBannerRepositoryTypeSupport<B extends Banner>
        extends AbstractRepositoryTypeSupport<B, BannerRepositoryContainer, BannerRepositoryContainer>
        implements BannerRepositoryTypeSupport<B> {

    protected AbstractBannerRepositoryTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    public Set<ModelProperty<? super B, ?>> getGrutSupportedProperties() {
        // По умолчанию список поддерживаемых полей пуст
        return emptySet();
    }

    @Override
    public Map<Long, ModifiedPaths> applyToGrutObjects(@NotNull Map<Long, Schema.TBannerV2.Builder> bannerBuilders,
                                                       @NotNull Collection<AppliedChanges<B>> appliedChangesList,
                                                       @NotNull BannersOperationContainer operationContainer) {
        return emptyMap();
    }
}
