package ru.yandex.direct.core.entity.banner.repository.type;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Field;
import org.jooq.Record;
import org.jooq.TableField;

import ru.yandex.direct.core.entity.banner.model.Banner;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;

/**
 * Абстрактный класс для реализации на базе него репозиторных тайп-саппортов конкретных ассетов.
 * <p>
 * Подходит для отношения один-к-одному к основной таблице banners.
 * <p>
 * Под капотом для вставки и обновления используется insert ... on duplicate key update.
 * Подходит для случая, когда поля базы хранятся непосредственно в баннере, без промежуточного контейнера.
 * <p>
 * При обновлении разбивает строки на 2 множества - (добавить или обновить), удалить.
 * <p>
 * Альтернатива: {@link AbstractFlatRelatedEntityRepositoryTypeSupport}.
 * Преимущество: более простое условие обновления в методе isUpsertEntity,
 * сложнее ошибиться при первоначальном написании и добавлении новых полей.
 * Недостаток: необходимо самостоятельно написать запрос insert ... on duplicate key update c помощью Jooq.
 *
 * @param <B> - интерфейс
 * @param <R> - тип записи Jooq в базе
 */
@ParametersAreNonnullByDefault
public abstract class AbstractFlatRelatedEntityUpsertRepositoryTypeSupport
        <B extends Banner, R extends Record>
        extends AbstractRelatedEntityUpsertRepositoryTypeSupport<B, R> {

    private final JooqMapper<B> jooqMapper;

    protected AbstractFlatRelatedEntityUpsertRepositoryTypeSupport(DslContextProvider dslContextProvider,
                                                                   TableField<R, Long> bannerIdField,
                                                                   JooqMapper<B> jooqMapper) {
        super(dslContextProvider, bannerIdField);
        this.jooqMapper = jooqMapper;
    }

    @Override
    public final <M extends B> void fillFromRecord(M model, Record record) {
        getJooqMapper().fromDb(record, model);
    }

    @Override
    public Collection<Field<?>> getFields() {
        return getJooqMapper().getFieldsToRead();
    }

    protected JooqMapper<B> getJooqMapper() {
        return jooqMapper;
    }

}
