package ru.yandex.direct.core.entity.banner.repository.type;

import java.util.Collection;
import java.util.Map;
import java.util.Set;

import ru.yandex.direct.core.entity.banner.container.BannerRepositoryContainer;
import ru.yandex.direct.core.entity.banner.container.BannersOperationContainer;
import ru.yandex.direct.core.entity.banner.model.Banner;
import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.direct.multitype.repository.RepositoryTypeSupport;
import ru.yandex.grut.objects.proto.client.Schema;

public interface BannerRepositoryTypeSupport<B extends Banner>
        extends RepositoryTypeSupport<B, BannerRepositoryContainer, BannerRepositoryContainer> {

    /**
     * Возвращает набор полей, для которых есть поддержка сохранения в грут
     * Если поле поддерживается, то TypeSupport должен уметь сохранять эти изменения в грут
     */
    Set<ModelProperty<? super B, ?>> getGrutSupportedProperties();

    /**
     * Применяет набор изменений appliedChangesList к объектам в груте
     * Метод вызывается для тех наборов изменений, в которых есть изменённые ModelProperties из списка,
     * полученного через {@link #getGrutSupportedProperties}
     *
     * @param bannerBuilders     мапа с грутовыми баннерами по bannerId
     * @param appliedChangesList наборы изменений
     * @return для каждого изменённого баннера нужно вернуть набор изменённых и удалённых полей.
     * Если грутовый объект не поменялся при выполнении метода, то можно для него ничего не указывать
     */
    Map<Long, ModifiedPaths> applyToGrutObjects(Map<Long, Schema.TBannerV2.Builder> bannerBuilders,
                                                Collection<AppliedChanges<B>> appliedChangesList,
                                                BannersOperationContainer operationContainer);
}
