package ru.yandex.direct.core.entity.banner.repository.type;

import java.util.Collection;
import java.util.List;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.EntryStream;
import org.jooq.Condition;
import org.jooq.Record;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannerRepositoryContainer;
import ru.yandex.direct.core.entity.banner.model.Banner;
import ru.yandex.direct.dbschema.ppc.enums.BannersBannerType;
import ru.yandex.direct.multitype.repository.RepositoryTypeSupportFacade;

import static java.util.Collections.singleton;
import static ru.yandex.direct.core.entity.banner.repository.BannerRepositoryConstants.BANNER_CLASS_TO_TYPE;
import static ru.yandex.direct.core.entity.banner.repository.BannerRepositoryConstants.TYPE_TO_BANNER_CLASS_SUPPLIER;
import static ru.yandex.direct.core.entity.banner.service.BannersUpdateOperationConstants.BANNER_TYPE_SUPPORT_CLASS_WHITE_LIST;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS;

@Component
@ParametersAreNonnullByDefault
public class BannerRepositoryTypeSupportFacade extends RepositoryTypeSupportFacade<Banner, BannersBannerType,
        BannerRepositoryContainer, BannerRepositoryContainer> {

    @Autowired
    public BannerRepositoryTypeSupportFacade(List<BannerRepositoryTypeSupport<? extends Banner>> typeSupports) {
        super(typeSupports, TYPE_TO_BANNER_CLASS_SUPPLIER, singleton(BANNERS.BANNER_TYPE),
                BANNER_TYPE_SUPPORT_CLASS_WHITE_LIST);
    }

    @Override
    protected BannersBannerType getModelType(Record record) {
        return record.get(BANNERS.BANNER_TYPE, BannersBannerType.class);
    }

    @Nullable
    @Override
    public Condition getConditionThatRecordAnyOfClasses(Collection<Class<? extends Banner>> classes) {
        List<BannersBannerType> types = EntryStream.of(BANNER_CLASS_TO_TYPE)
                .filterKeys(runtimeClass -> classes.stream().anyMatch(c -> c.isAssignableFrom(runtimeClass)))
                .values()
                .toList();
        return (types.size() == BANNER_CLASS_TO_TYPE.size()) ? null : BANNERS.BANNER_TYPE.in(types);
    }

}

