package ru.yandex.direct.core.entity.banner.repository.type

import com.google.common.base.Preconditions.checkState

data class ModifiedPaths @JvmOverloads constructor(
    val setPaths: Set<String>,
    val removePaths: Set<String> = emptySet(),
    val vcardIdToCheckIfExist: Long? = null,
    val creativeIdToCheckIfExist: Long? = null
)

// Билдер для джавы, т.к. из java нельзя сконструировать объект, указав опциональные именованные аргументы
class ModifiedPathsBuilder {
    var setPaths: Set<String> = emptySet()
    var removePaths: Set<String> = emptySet()
    var vcardIdToCheckIfExist: Long? = null
    var creativeIdToCheckIfExist: Long? = null

    fun withSetPaths(setPaths: Set<String>): ModifiedPathsBuilder {
        this.setPaths = setPaths
        return this
    }

    fun withRemovePaths(removePaths: Set<String>): ModifiedPathsBuilder {
        this.removePaths = removePaths
        return this
    }

    fun withVcardIdToCheckIfExist(vcardIdToCheckIfExist: Long): ModifiedPathsBuilder {
        this.vcardIdToCheckIfExist = vcardIdToCheckIfExist
        return this
    }

    fun withCreativeIdToCheckIfExist(creativeIdToCheckIfExist: Long): ModifiedPathsBuilder {
        this.creativeIdToCheckIfExist = creativeIdToCheckIfExist
        return this
    }

    fun build(): ModifiedPaths {
        checkState(setPaths.isNotEmpty() || removePaths.isNotEmpty())
        return ModifiedPaths(setPaths, removePaths, vcardIdToCheckIfExist, creativeIdToCheckIfExist)
    }
}
