package ru.yandex.direct.core.entity.banner.service;

import java.util.List;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.repository.BannerRepository;
import ru.yandex.direct.core.entity.banner.service.validation.DeleteBannerValidationService;
import ru.yandex.direct.core.entity.client.service.ClientGeoService;
import ru.yandex.direct.core.entity.creative.repository.CreativeRepository;
import ru.yandex.direct.core.entity.metrika.repository.MetrikaCampaignRepository;
import ru.yandex.direct.core.entity.moderation.repository.ModerationRepository;
import ru.yandex.direct.core.entity.redirectcheckqueue.repository.RedirectCheckQueueRepository;
import ru.yandex.direct.core.entity.turbolanding.repository.TurboLandingRepository;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.dbutil.sharding.ShardSupport;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.operation.Applicability;

/**
 * Factory для создания {@link BannerDeleteOperation}
 */
@Component
public class BannerDeleteOperationFactory {
    private final BannerRepository bannerRepository;
    private final CreativeRepository creativeRepository;
    private final TurboLandingRepository turboLandingRepository;
    private final MetrikaCampaignRepository metrikaCampaignRepository;
    private final ModerationRepository moderationRepository;
    private final RedirectCheckQueueRepository redirectCheckQueueRepository;

    private final ClientGeoService clientGeoService;
    private final DslContextProvider ppcDslContextProvider;
    private final ShardSupport shardSupport;
    private final DeleteBannerValidationService deleteBannerValidationService;

    public BannerDeleteOperationFactory(
            BannerRepository bannerRepository,
            CreativeRepository creativeRepository,
            TurboLandingRepository turboLandingRepository,
            MetrikaCampaignRepository metrikaCampaignRepository,
            ModerationRepository moderationRepository,
            RedirectCheckQueueRepository redirectCheckQueueRepository,
            ClientGeoService clientGeoService,
            DslContextProvider ppcDslContextProvider,
            ShardSupport shardSupport,
            DeleteBannerValidationService deleteBannerValidationService) {
        this.bannerRepository = bannerRepository;
        this.creativeRepository = creativeRepository;
        this.turboLandingRepository = turboLandingRepository;
        this.metrikaCampaignRepository = metrikaCampaignRepository;
        this.moderationRepository = moderationRepository;
        this.redirectCheckQueueRepository = redirectCheckQueueRepository;
        this.clientGeoService = clientGeoService;
        this.ppcDslContextProvider = ppcDslContextProvider;
        this.shardSupport = shardSupport;
        this.deleteBannerValidationService = deleteBannerValidationService;
    }

    public BannerDeleteOperation createBannerDeleteOperation(int shard, ClientId clientId,
                                                             long operatorUid, List<Long> adIds,
                                                             Applicability applicability) {
        return new BannerDeleteOperation(shard, clientId, operatorUid, adIds, applicability,
                ppcDslContextProvider, shardSupport, deleteBannerValidationService, clientGeoService,
                bannerRepository, creativeRepository, turboLandingRepository,
                metrikaCampaignRepository, moderationRepository, redirectCheckQueueRepository);
    }
}
