package ru.yandex.direct.core.entity.banner.service;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import org.slf4j.Logger;

import ru.yandex.direct.core.entity.banner.model.BannerWithAdGroupId;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.model.ModelWithId;

import static java.util.stream.Collectors.toList;
import static ru.yandex.direct.utils.FunctionalUtils.listToSet;
import static ru.yandex.direct.utils.StringUtils.joinLongsToString;

public class BannerLogUtils {

    private BannerLogUtils() {
    }

    public static <T extends ModelWithId> void logBannersCount(Logger logger, String message,
                                                               Collection<T> banners) {
        Map<String, Long> classToCount = new HashMap<>();
        banners.forEach(x -> classToCount.merge(x.getClass().getSimpleName(), 1L, Long::sum));
        logger.info(message, classToCount);
    }

    public static <T extends ModelWithId> void logModelChangesIds(Logger logger, String message,
                                                                  Collection<ModelChanges<T>> modelChanges) {
        var ids = joinLongsToString(modelChanges.stream()
                .map(ModelChanges::getId)
                .collect(toList()));
        logger.info(message, ids);
    }

    public static <T extends ModelWithId> void logBannersCountModelChanges(Logger logger,
                                                                           Collection<ModelChanges<T>> allModelChanges,
                                                                           Collection<ModelChanges<T>> validChanges) {

        Set<Long> validIds = listToSet(validChanges, ModelChanges::getId);
        var invalidBanners = allModelChanges.stream()
                .filter(x -> !validIds.contains(x.getId()))
                .collect(toList());

        logModelChangesIds(logger, "Valid banner ids in onAppliedChangesValidated: {}", validChanges);

        logModelChangesIds(logger, "Invalid banner ids in onAppliedChangesValidated: {}", invalidBanners);
    }

    public static void logBannersCount(Logger logger,
                                       Collection<BannerWithAdGroupId> allBanners,
                                       Collection<BannerWithAdGroupId> validBanners) {
        Set<BannerWithAdGroupId> validModelsSet = new HashSet<>(validBanners);
        var invalidBanners = allBanners.stream()
                .filter(banner -> !validModelsSet.contains(banner))
                .collect(toList());

        logBannersCount(logger, "Valid banners in onModelsValidated: {}", validBanners);
        logBannersCount(logger, "Invalid banners in onModelsValidated: {}", invalidBanners);
    }

}
