package ru.yandex.direct.core.entity.banner.service;

import javax.annotation.Nullable;

import ru.yandex.direct.core.entity.adgroup.model.AdGroupForBannerOperation;
import ru.yandex.direct.core.entity.adgroup.model.StatusModerate;
import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerWithAdGroupId;
import ru.yandex.direct.core.entity.banner.model.BannerWithModerationStatuses;
import ru.yandex.direct.core.entity.campaign.model.CampaignStatusModerate;
import ru.yandex.direct.core.entity.campaign.model.CommonCampaign;
import ru.yandex.direct.model.AppliedChanges;

import static com.google.common.base.Preconditions.checkNotNull;

public class BannerModerationUtils {
    private BannerModerationUtils() {
    }

    public static boolean isEffectiveSaveDraft(BannersAddOperationContainer container, BannerWithAdGroupId banner) {
        var campaign = container.getCampaign(banner);
        checkNotNull(campaign,
                "could not get campaign for banner with adgroupId %s and class %s",
                banner.getAdGroupId(), banner.getClass());
        boolean moderationAllowed = campaign.getStatusModerate() != CampaignStatusModerate.NEW;

        boolean isSaveDraft;
        @Nullable AdGroupForBannerOperation adGroup = container.getAdGroup(banner);
        if (container.getModerationMode().isDefault() && adGroup != null) {
            isSaveDraft = adGroup.getStatusModerate() == StatusModerate.NEW;
        } else {
            isSaveDraft = !container.getModerationMode().isForceModerate();
        }

        // фактическая отправка баннера в черновики происходит,
        // если кампания еще черновик или выставлен флаг saveDraft
        return !moderationAllowed || isSaveDraft;
    }

    public static boolean bannerBecameDraft(AppliedChanges<? extends BannerWithModerationStatuses> bannerChanges) {
        return bannerChanges.getNewValue(BannerWithModerationStatuses.STATUS_MODERATE) == BannerStatusModerate.NEW;
    }

    public static boolean bannerWasDraft(AppliedChanges<? extends BannerWithModerationStatuses> bannerChanges) {
        return bannerChanges.getOldValue(BannerWithModerationStatuses.STATUS_MODERATE) == BannerStatusModerate.NEW;
    }

    public static boolean bannerIsOnModeration(BannerWithModerationStatuses banner) {
        return banner.getStatusModerate() == BannerStatusModerate.READY;
    }

    public static boolean moderateUnconditionally(AppliedChanges<? extends BannerWithModerationStatuses> bannerChanges) {
        return bannerWasDraft(bannerChanges) && !bannerBecameDraft(bannerChanges);
    }

    public static boolean campaignIsDraft(CommonCampaign campaign) {
        return campaign.getStatusModerate() == CampaignStatusModerate.NEW;
    }
}
