package ru.yandex.direct.core.entity.banner.service;

import java.util.List;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainerService;
import ru.yandex.direct.core.entity.banner.model.BannerWithAdGroupId;
import ru.yandex.direct.core.entity.banner.service.moderation.ModerationMode;
import ru.yandex.direct.core.entity.banner.service.type.add.BannerAddOperationTypeSupportFacade;
import ru.yandex.direct.core.entity.banner.service.validation.type.add.BannerAddValidationTypeSupportFacade;
import ru.yandex.direct.core.entity.client.repository.ClientRepository;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.core.entity.user.repository.UserRepository;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.operation.Applicability;
import ru.yandex.direct.rbac.RbacRole;
import ru.yandex.direct.rbac.RbacService;

@Component
@ParametersAreNonnullByDefault
public class BannersAddOperationFactory {

    private final UserRepository userRepository;

    private final ClientRepository clientRepository;

    private final BannersAddOperationContainerService bannersOperationContainerService;

    private final BannerAddValidationTypeSupportFacade validationTypeSupportFacade;

    private final BannerAddOperationTypeSupportFacade addOperationTypeSupportFacade;

    private final RbacService rbacService;

    private final FeatureService featureService;

    private final ShardHelper shardHelper;

    private final BannersAddExecutionFacade bannersAddExecutionService;

    @Autowired
    public BannersAddOperationFactory(UserRepository userRepository,
                                      ClientRepository clientRepository,
                                      BannersAddOperationContainerService bannersOperationContainerService,
                                      BannerAddValidationTypeSupportFacade validationTypeSupportFacade,
                                      BannerAddOperationTypeSupportFacade addOperationTypeSupportFacade,
                                      BannersAddExecutionFacade bannersAddExecutionService,
                                      RbacService rbacService,
                                      FeatureService featureService,
                                      ShardHelper shardHelper) {
        this.userRepository = userRepository;
        this.clientRepository = clientRepository;
        this.bannersOperationContainerService = bannersOperationContainerService;
        this.validationTypeSupportFacade = validationTypeSupportFacade;
        this.addOperationTypeSupportFacade = addOperationTypeSupportFacade;
        this.bannersAddExecutionService = bannersAddExecutionService;
        this.rbacService = rbacService;
        this.featureService = featureService;
        this.shardHelper = shardHelper;
    }

    public BannersAddOperation createPartialAddOperation(
            List<BannerWithAdGroupId> bannersToAdd,
            ClientId clientId,
            Long operatorUid,
            boolean saveDraft
    ) {
        return createAddOperation(Applicability.PARTIAL,
                false,
                bannersToAdd,
                clientId,
                operatorUid,
                saveDraft,
                false,
                DatabaseMode.ONLY_MYSQL);
    }

    public BannersAddOperation createPartialAddOperation(
            List<BannerWithAdGroupId> bannersToAdd,
            ClientId clientId,
            Long operatorUid,
            boolean saveDraft,
            boolean isCopy
    ) {
        return createAddOperation(Applicability.PARTIAL,
                false,
                bannersToAdd,
                clientId,
                operatorUid,
                saveDraft,
                isCopy,
                DatabaseMode.ONLY_MYSQL);
    }

    public BannersAddOperation createFullAddOperation(
            List<BannerWithAdGroupId> bannersToAdd,
            ClientId clientId,
            Long operatorUid,
            boolean saveDraft,
            DatabaseMode databaseMode
    ) {
        return createAddOperation(Applicability.FULL,
                false,
                bannersToAdd,
                clientId,
                operatorUid,
                saveDraft,
                false,
                databaseMode);
    }

    public BannersAddOperation createFullAddOperation(
            List<BannerWithAdGroupId> bannersToAdd,
            ClientId clientId,
            Long operatorUid,
            boolean saveDraft
    ) {
        return createAddOperation(Applicability.FULL,
                false,
                bannersToAdd,
                clientId,
                operatorUid,
                saveDraft,
                false,
                DatabaseMode.ONLY_MYSQL);
    }

    public BannersAddOperation createAddOperation(
            Applicability applicability,
            boolean partOfComplexOperation,
            List<BannerWithAdGroupId> bannersToAdd,
            ClientId clientId,
            Long operatorUid,
            boolean saveDraft,
            boolean isCopyAction
    ) {
        return createAddOperation(applicability, partOfComplexOperation, bannersToAdd,
                clientId, operatorUid, saveDraft, isCopyAction, DatabaseMode.ONLY_MYSQL);
    }

    public BannersAddOperation createAddOperation(
            Applicability applicability,
            boolean partOfComplexOperation,
            List<BannerWithAdGroupId> bannersToAdd,
            ClientId clientId,
            Long operatorUid,
            boolean saveDraft,
            boolean isCopyAction,
            DatabaseMode databaseMode
    ) {
        int shard = shardHelper.getShardByClientIdStrictly(clientId);
        Set<String> clientEnabledFeatures = featureService.getEnabledForClientId(clientId);

        return createAddOperation(applicability,
                partOfComplexOperation,
                bannersToAdd,
                shard,
                clientId,
                operatorUid,
                saveDraft,
                isCopyAction,
                false,
                false,
                databaseMode,
                clientEnabledFeatures);
    }

    public BannersAddOperation createAddOperation(
            List<BannerWithAdGroupId> bannersToAdd,
            ClientId clientId,
            Long operatorUid,
            boolean saveDraft,
            boolean isFromApi
    ) {
        return createAddOperation(bannersToAdd, clientId, operatorUid, saveDraft, isFromApi, DatabaseMode.ONLY_MYSQL);
    }

    public BannersAddOperation createAddOperation(
            List<BannerWithAdGroupId> bannersToAdd,
            ClientId clientId,
            Long operatorUid,
            boolean saveDraft,
            boolean isFromApi,
            DatabaseMode databaseMode
    ) {
        int shard = shardHelper.getShardByClientIdStrictly(clientId);
        Set<String> clientEnabledFeatures = featureService.getEnabledForClientId(clientId);

        return createAddOperation(Applicability.PARTIAL,
                false,
                bannersToAdd,
                shard,
                clientId,
                operatorUid,
                saveDraft,
                false,
                isFromApi,
                false,
                databaseMode,
                clientEnabledFeatures);
    }


    public BannersAddOperation createAddOperation(
            Applicability applicability,
            boolean partOfComplexOperation,
            List<BannerWithAdGroupId> bannersToAdd,
            int shard,
            ClientId clientId,
            Long operatorUid,
            boolean saveDraft,
            boolean isCopyAction,
            boolean isFromApi,
            boolean isUcPreValidation,
            Set<String> clientEnabledFeatures) {
        return createAddOperation(applicability, partOfComplexOperation, bannersToAdd, shard, clientId,
                operatorUid, saveDraft, isCopyAction, isFromApi, isUcPreValidation, DatabaseMode.ONLY_MYSQL,
                clientEnabledFeatures);
    }

    public BannersAddOperation createAddOperation(
            Applicability applicability,
            boolean partOfComplexOperation,
            List<BannerWithAdGroupId> bannersToAdd,
            int shard,
            ClientId clientId,
            Long operatorUid,
            boolean saveDraft,
            boolean isCopyAction,
            boolean isFromApi,
            boolean isUcPreValidation,
            DatabaseMode databaseMode,
            Set<String> clientEnabledFeatures) {
        return createAddOperation(applicability, partOfComplexOperation, bannersToAdd, shard, clientId, operatorUid,
                saveDraft ? ModerationMode.FORCE_SAVE_DRAFT : ModerationMode.FORCE_MODERATE, isCopyAction, isFromApi,
                isUcPreValidation, databaseMode, clientEnabledFeatures);
    }

    public BannersAddOperation createAddOperation(
            Applicability applicability,
            boolean partOfComplexOperation,
            List<BannerWithAdGroupId> bannersToAdd,
            int shard,
            ClientId clientId,
            Long operatorUid,
            ModerationMode moderationMode,
            boolean isCopyAction,
            boolean isFromApi,
            boolean isUcPreValidation,
            DatabaseMode databaseMode,
            Set<String> clientEnabledFeatures) {

        RbacRole operatorRole = rbacService.getUidRole(operatorUid);

        return new BannersAddOperation(applicability, partOfComplexOperation,
                bannersToAdd,
                userRepository,
                clientRepository,
                bannersOperationContainerService,
                bannersAddExecutionService,
                validationTypeSupportFacade,
                addOperationTypeSupportFacade,
                rbacService,
                shard,
                clientId,
                operatorUid,
                moderationMode,
                isCopyAction,
                isFromApi,
                isUcPreValidation,
                databaseMode,
                operatorRole,
                clientEnabledFeatures);
    }

    public BannersAddOperation createPartialAddOperationAsPartOfComplexOperation(
            List<BannerWithAdGroupId> banners, long operatorUid, ClientId clientId,
            ModerationMode moderationMode, boolean isUcPreValidation, DatabaseMode databaseMode) {
        int shard = shardHelper.getShardByClientId(clientId);
        var enabledFeatures = featureService.getEnabledForClientId(clientId);
        return createAddOperation(
                Applicability.PARTIAL,
                true,
                banners,
                shard,
                clientId,
                operatorUid,
                moderationMode,
                false,
                false,
                isUcPreValidation,
                databaseMode,
                enabledFeatures
        );
    }
}
