package ru.yandex.direct.core.entity.banner.service;

import java.util.List;
import java.util.stream.Collectors;

import one.util.streamex.StreamEx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.banner.container.BannerAdditionalActionsContainer;
import ru.yandex.direct.core.entity.banner.container.BannerRepositoryContainer;
import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainerImpl;
import ru.yandex.direct.core.entity.banner.model.Banner;
import ru.yandex.direct.core.entity.banner.service.execution.BannersUpdateExecutionGrutService;
import ru.yandex.direct.core.entity.banner.service.execution.BannersUpdateExecutionMysqlService;
import ru.yandex.direct.model.AppliedChanges;

@Service
public class BannersUpdateExecutionFacade {

    private static final Logger logger = LoggerFactory.getLogger(BannersUpdateExecutionFacade.class);

    private final BannersUpdateExecutionMysqlService bannersUpdateExecutionMysqlService;
    private final BannersUpdateExecutionGrutService bannersUpdateExecutionGrutService;

    @Autowired
    public BannersUpdateExecutionFacade(BannersUpdateExecutionMysqlService bannersUpdateExecutionMysqlService,
                                        BannersUpdateExecutionGrutService bannersUpdateExecutionGrutService) {
        this.bannersUpdateExecutionMysqlService = bannersUpdateExecutionMysqlService;
        this.bannersUpdateExecutionGrutService = bannersUpdateExecutionGrutService;
    }

    public <T extends Banner> List<Long> execute(List<AppliedChanges<T>> applicableAppliedChanges,
                                                 BannersUpdateOperationContainerImpl operationContainer,
                                                 BannerRepositoryContainer repositoryContainer,
                                                 BannerAdditionalActionsContainer additionalActionsContainer) {
        switch (operationContainer.getDatabaseMode()) {
            case ONLY_MYSQL: {
                return bannersUpdateExecutionMysqlService.execute(applicableAppliedChanges, operationContainer,
                        repositoryContainer, additionalActionsContainer);
            }
            case ONLY_GRUT: {
                throw new UnsupportedOperationException("not supported yet");
            }
            case MYSQL_AND_GRUT: {
                List<Long> resultList = bannersUpdateExecutionMysqlService.execute(applicableAppliedChanges,
                        operationContainer, repositoryContainer, additionalActionsContainer);

                try {
                    bannersUpdateExecutionGrutService.execute(applicableAppliedChanges, operationContainer);
                } catch (RuntimeException e) {
                    // не показываем пользователю ошибку, т.к. в mysql сохранились корректные данные
                    List<Long> bannerIds = StreamEx.of(applicableAppliedChanges)
                            .map(ac -> ac.getModel().getId())
                            .collect(Collectors.toList());
                    logger.error(String.format("error in banners grut update for bannerIds %s", bannerIds), e);
                }
                return resultList;
            }
            default: {
                throw new IllegalArgumentException("Unsupported database mode: " + operationContainer.getDatabaseMode());
            }
        }
    }
}
