package ru.yandex.direct.core.entity.banner.service;

import java.util.List;
import java.util.Map;
import java.util.Set;

import one.util.streamex.StreamEx;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.banner.container.BannerAdditionalActionsContainer;
import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithModerationStatuses;
import ru.yandex.direct.core.entity.banner.type.moderation.update.DefaultUpdateOperationModerationProcessor;
import ru.yandex.direct.core.entity.banner.type.moderation.update.UpdateOperationModerationProcessor;
import ru.yandex.direct.model.AppliedChanges;

import static java.util.function.Function.identity;

@Service
public class BannersUpdateModerationService {
    private final DefaultUpdateOperationModerationProcessor defaultProcessor;
    private final Map<Class, UpdateOperationModerationProcessor> processors;

    @Autowired
    public BannersUpdateModerationService(DefaultUpdateOperationModerationProcessor defaultProcessor,
                                             List<UpdateOperationModerationProcessor> processors) {
        this.defaultProcessor = defaultProcessor;
        this.processors = StreamEx.of(processors)
                .remove(processor -> processor instanceof DefaultUpdateOperationModerationProcessor)
                .mapToEntry(processor -> processor.getProcessedClass(), identity())
                .toMap();
    }

    @SuppressWarnings("unchecked")
    public void sendBannersToModeration(
            BannersUpdateOperationContainer parametersContainer,
            BannerAdditionalActionsContainer additionalActionsContainer,
            Set<Long> bannerIdsToModerate,
            List<AppliedChanges<BannerWithModerationStatuses>> bannerChanges) {
        StreamEx.of(bannerChanges)
                .groupingBy(this::getProcessor)
                .forEach((processor, changes) -> processor.process(
                        additionalActionsContainer,
                        parametersContainer,
                        changes,
                        bannerIdsToModerate));
    }

    private UpdateOperationModerationProcessor getProcessor(
            AppliedChanges<BannerWithModerationStatuses> bannerChange) {
        var banner = bannerChange.getModel();
        return processors.getOrDefault(banner.getClass(), defaultProcessor);
    }
}
