package ru.yandex.direct.core.entity.banner.service;

import java.util.Set;

import ru.yandex.direct.core.entity.banner.model.Banner;
import ru.yandex.direct.core.entity.banner.model.BannerWithBannerImageModeration;
import ru.yandex.direct.core.entity.banner.model.BannerWithButtonModeration;
import ru.yandex.direct.core.entity.banner.model.BannerWithCreativeModeration;
import ru.yandex.direct.core.entity.banner.model.BannerWithDisplayHrefModeration;
import ru.yandex.direct.core.entity.banner.model.BannerWithImageModeration;
import ru.yandex.direct.core.entity.banner.model.BannerWithLanguage;
import ru.yandex.direct.core.entity.banner.model.BannerWithLogoModeration;
import ru.yandex.direct.core.entity.banner.model.BannerWithPixels;
import ru.yandex.direct.core.entity.banner.model.BannerWithSitelinksModeration;
import ru.yandex.direct.core.entity.banner.model.BannerWithStatusArchived;
import ru.yandex.direct.core.entity.banner.model.BannerWithTitle;
import ru.yandex.direct.core.entity.banner.model.BannerWithTurboLandingModeration;
import ru.yandex.direct.core.entity.banner.model.BannerWithVcardModeration;
import ru.yandex.direct.core.entity.banner.model.ImmutableBanner;

public class BannersUpdateOperationConstants {

    /**
     * Если саппорт навешен на класс, который есть в этом белом списке или на класс, который наследуются от класса,
     * который есть в этом белом списке - то такой саппорт будет вызываться всегда, независимо от изменившихся данных.
     */
    public static final Set<Class<? extends Banner>> BANNER_TYPE_SUPPORT_CLASS_WHITE_LIST = Set.of(

            // нужна проверка на то, что баннер не архивный, которая должна выполняться всегда
            // (баннер может менять статус архивности не только через операцию, но и через отдельную ручку)
            BannerWithStatusArchived.class,

            // language должен пересчитывать при изменении любых других полей поэтому должен вызываться всегда
            BannerWithLanguage.class,

            // нужна проверка на то, что баннер не поменялся или черновик, должна выполняться всегда
            ImmutableBanner.class,

            // статусы модерации должны пересчитываться всегда
            BannerWithBannerImageModeration.class,
            BannerWithCreativeModeration.class,
            BannerWithDisplayHrefModeration.class,
            BannerWithImageModeration.class,
            BannerWithSitelinksModeration.class,
            BannerWithTurboLandingModeration.class,
            BannerWithVcardModeration.class,
            BannerWithButtonModeration.class,
            BannerWithLogoModeration.class,

            // Валидация пикселей пропускается в рамках комплексной операции обновления групп (передаётся флаг
            // RetargetingConditionsUpdateOperation.skipPixelValidation = true)
            // Поэтому на уровне баннеров требуется безусловная валидация пикселей.
            // Покрыто юнит тестом leaveDcmPixel_PublicToPrivateRetargeting_NegativeTest
            BannerWithPixels.class,

            // Постоянная проверка заголовка нужна, чтобы люди уменьшали длинну заголовков в уже существующих
            // видео баннерах cpm компаний на морде.
            BannerWithTitle.class
            );

}
