package ru.yandex.direct.core.entity.banner.service.execution;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.banner.container.BannerAdditionalActionsContainer;
import ru.yandex.direct.core.entity.banner.container.BannerRepositoryContainer;
import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainerImpl;
import ru.yandex.direct.core.entity.banner.model.BannerWithAdGroupId;
import ru.yandex.direct.core.entity.banner.repository.BannerModifyRepository;
import ru.yandex.direct.core.entity.banner.service.BannerAdditionalActionsService;
import ru.yandex.direct.core.entity.banner.service.type.add.BannerAddOperationTypeSupportFacade;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;

@Service
public class BannersAddExecutionMysqlService implements BannersAddExecutionService {

    private final DslContextProvider ppcDslContextProvider;
    private final BannerModifyRepository bannerModifyRepository;
    private final BannerAddOperationTypeSupportFacade addOperationTypeSupportFacade;
    private final BannerAdditionalActionsService additionalActionsService;

    @Autowired
    public BannersAddExecutionMysqlService(DslContextProvider ppcDslContextProvider,
                                           BannerModifyRepository bannerModifyRepository,
                                           BannerAddOperationTypeSupportFacade addOperationTypeSupportFacade,
                                           BannerAdditionalActionsService additionalActionsService) {
        this.ppcDslContextProvider = ppcDslContextProvider;
        this.bannerModifyRepository = bannerModifyRepository;
        this.addOperationTypeSupportFacade = addOperationTypeSupportFacade;
        this.additionalActionsService = additionalActionsService;
    }

    @Override
    public List<Long> execute(List<BannerWithAdGroupId> validBannersToApply,
                              BannersAddOperationContainerImpl operationContainer,
                              BannerRepositoryContainer repositoryContainer,
                              BannerAdditionalActionsContainer additionalActionsContainer) {
        List<Long> addedBannerIds = new ArrayList<>(validBannersToApply.size());
        ppcDslContextProvider.ppcTransaction(operationContainer.getShard(), conf -> {
            DSLContext dsl = conf.dsl();
            addedBannerIds.addAll(bannerModifyRepository.add(dsl, repositoryContainer, validBannersToApply));
            addOperationTypeSupportFacade
                    .updateRelatedEntitiesInTransaction(dsl, operationContainer, validBannersToApply);
            additionalActionsService
                    .processAdditionalActionsContainer(dsl, additionalActionsContainer);
        });
        return addedBannerIds;
    }

    @Override
    public void afterExecution(Map<Integer, BannerWithAdGroupId> validModelsMapToApply,
                               BannersAddOperationContainerImpl operationContainer) {
        var validBannersToApply = new ArrayList<>(validModelsMapToApply.values());
        addOperationTypeSupportFacade.afterExecution(operationContainer, validBannersToApply);
    }
}
